/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact.AdditionalContentImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact.ArtifactArgument;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact.ArtifactOutputVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.AdditionalContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactImpl
extends SPIDataObject
implements Artifact {
    private static final String ARTIFACT_TYPE = "sdd-dd:ArtifactType";
    private static final String ARGUMENT_LIST_TYPE = "sdd-dd:ArgumentListType";
    private static final String OUTPUT_VARIABLE_LIST_TYPE = "sdd-dd:OutputVariableListType";

    public ArtifactImpl(Element artifactObject, SPISessionImpl session) {
        super(artifactObject, session, ARTIFACT_TYPE);
    }

    @Override
    public String getContentReference() {
        return this.isSetAttribute("contentRef") ? this.getAttribute("contentRef") : null;
    }

    @Override
    public String getPackageType() {
        return this.isSetAttribute("type") ? this.getAttribute("type") : null;
    }

    @Override
    public Collection<AdditionalContent> getAdditionalContents() {
        Collection<Element> additionalContentList = this.getChildren("AdditionalContent");
        ArrayList<AdditionalContent> crcList = new ArrayList<AdditionalContent>();
        for (Element element : additionalContentList) {
            AdditionalContentImpl temp = new AdditionalContentImpl(element, this.session);
            crcList.add(temp);
        }
        return crcList;
    }

    @Override
    public BigInteger getWeight() {
        return this.isSetAttribute("weight") ? new BigInteger(this.getAttribute("weight")) : null;
    }

    @Override
    public Collection<ArtifactArgument> getArguments() {
        ArrayList<ArtifactArgument> arguments = new ArrayList<ArtifactArgument>();
        if (this.isSetElement("Arguments")) {
            Element argumentsElement = this.getChild("Arguments");
            Collection<Element> list = this.session.getChildren(argumentsElement, "Argument");
            for (Element arg : list) {
                String name = arg.getAttribute("name");
                String value = arg.getAttribute("value");
                String required = arg.getAttribute("required");
                ArtifactArgument artarg = new ArtifactArgument(name.length() > 0 ? name : null, value.length() > 0 ? value : null, required.length() > 0 ? Boolean.valueOf(required) : null);
                arguments.add(artarg);
            }
        }
        return arguments;
    }

    @Override
    public Collection<ArtifactOutputVariable> getOutputVariables() {
        ArrayList<ArtifactOutputVariable> outputVariables = new ArrayList<ArtifactOutputVariable>();
        if (this.isSetElement("OutputVariables")) {
            Element ovlElement = this.getChild("OutputVariables");
            Collection<Element> list = this.session.getChildren(ovlElement, "OutputVariable");
            for (Element arg : list) {
                String id = arg.getAttribute("id");
                String outputParameterName = arg.getAttribute("outputParameterName");
                ArtifactOutputVariable artOV = new ArtifactOutputVariable(id.length() > 0 ? id : null, outputParameterName.length() > 0 ? outputParameterName : null);
                outputVariables.add(artOV);
            }
        }
        return outputVariables;
    }

    @Override
    public String getResourceReference() {
        return this.isSetAttribute("resourceRef") ? this.getAttribute("resourceRef") : null;
    }

    @Override
    public void setPackageType(String packageType) {
        if (packageType == null) {
            this.unSetAttribute("type");
        } else {
            this.setAttribute("type", packageType);
        }
    }

    @Override
    public void setContentReference(String packageContentReference) {
        if (packageContentReference == null) {
            this.unSetAttribute("contentRef");
        } else {
            this.setAttribute("contentRef", packageContentReference);
        }
    }

    @Override
    public void setAdditionalContents(Collection<AdditionalContent> newAdditionalContents) {
        if (newAdditionalContents != null) {
            this.removeContent(this.getChildren("AdditionalContent", false));
            this.addContent(newAdditionalContents);
        } else {
            this.unSetElement("AdditionalContent");
        }
    }

    @Override
    public void setWeight(BigInteger weight) {
        if (weight == null) {
            this.unSetAttribute("weight");
        } else {
            this.setAttribute("weight", weight.toString());
        }
    }

    @Override
    public void setArguments(Collection<ArtifactArgument> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            this.unSetElement("Arguments");
        } else {
            Element argumentsElement = this.session.createDeploymentElement("Arguments");
            for (ArtifactArgument arg : arguments) {
                Element argElement = this.session.createDeploymentElement("Argument");
                argElement.setAttribute("name", arg.getName());
                argElement.setAttribute("value", arg.getValue());
                argElement.setAttribute("required", arg.getRequired().toString());
                this.session.insertNode((Node)argumentsElement, (Node)argElement, ARGUMENT_LIST_TYPE);
            }
            this.setContent(argumentsElement);
        }
    }

    @Override
    public void setOutputVariables(Collection<ArtifactOutputVariable> outputVariables) {
        if (outputVariables == null || outputVariables.isEmpty()) {
            this.unSetElement("OutputVariables");
        } else {
            Element outputVariablesElement = this.session.createDeploymentElement("OutputVariables");
            for (ArtifactOutputVariable artOV : outputVariables) {
                Element outputV = this.session.createDeploymentElement("OutputVariable");
                outputV.setAttribute("id", artOV.getOutputVariableID());
                outputV.setAttribute("outputParameterName", artOV.getArtifactParameter());
                this.session.insertNode((Node)outputVariablesElement, (Node)outputV, OUTPUT_VARIABLE_LIST_TYPE);
            }
            this.setContent(outputVariablesElement);
        }
    }

    @Override
    public void setResourceReference(String resourceReference) {
        if (resourceReference == null) {
            this.unSetAttribute("resourceRef");
        } else {
            this.setAttribute("resourceRef", resourceReference);
        }
    }

    public String toString() {
        String tmp = new String("Content Ref: \"" + this.getAttribute("contentRef") + "\"\n");
        tmp = String.valueOf(tmp) + "Resource Ref: \"" + this.getAttribute("resourceRef") + "\"\n";
        return tmp;
    }
}

