/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.AlternativeRequirementType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.StringType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.TranslatableStringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementType {
    public static Collection<Requirement> merge(Collection<Requirement> requirements1, Collection<Requirement> requirements2) {
        ArrayList<Requirement> requirementsToRemove = new ArrayList<Requirement>();
        for (Requirement requirement1 : requirements1) {
            for (Requirement requirement2 : requirements2) {
                if (requirementsToRemove.contains(requirement2) || !RequirementType.equals(requirement1, requirement2)) continue;
                requirementsToRemove.add(requirement2);
                requirement1 = RequirementType.merge(requirement1, requirement2);
            }
        }
        requirements2.removeAll(requirementsToRemove);
        ArrayList<Requirement> finalRequirements = new ArrayList<Requirement>();
        finalRequirements.addAll(requirements1);
        finalRequirements.addAll(requirements2);
        return finalRequirements;
    }

    public static Requirement merge(Requirement requirement1, Requirement requirement2) {
        requirement1.setDescription(TranslatableStringType.merge(requirement1.getDescription(), requirement2.getDescription()));
        requirement1.setDisplayName(TranslatableStringType.merge(requirement1.getDisplayName(), requirement2.getDisplayName()));
        requirement1.setShortDescription(TranslatableStringType.merge(requirement1.getShortDescription(), requirement2.getShortDescription()));
        requirement1.setAlternativeRequirements(AlternativeRequirementType.merge(requirement1.getAlternativeRequirements(), requirement2.getAlternativeRequirements()));
        return requirement1;
    }

    public static boolean equals(Requirement requirement1, Requirement requirement2) {
        boolean foundEquals;
        if (requirement1.getOperations().size() != requirement2.getOperations().size()) {
            return false;
        }
        Iterator operationIter1 = requirement1.getOperations().iterator();
        while (operationIter1.hasNext()) {
            Iterator operationIter2 = requirement2.getOperations().iterator();
            String operation1 = (String)operationIter1.next();
            foundEquals = false;
            while (!foundEquals && operationIter2.hasNext()) {
                if (!StringType.equals(operation1, (String)operationIter2.next())) continue;
                foundEquals = true;
            }
            if (foundEquals) continue;
            return false;
        }
        if (requirement1.getResourceConstraints().size() != requirement2.getResourceConstraints().size()) {
            return false;
        }
        Iterator constraintIter1 = requirement1.getResourceConstraints().iterator();
        while (constraintIter1.hasNext()) {
            Iterator constraintIter2 = requirement2.getResourceConstraints().iterator();
            RequirementResourceConstraint constraint1 = (RequirementResourceConstraint)constraintIter1.next();
            foundEquals = false;
            while (!foundEquals && constraintIter2.hasNext()) {
                if (!RequirementResourceConstraintType.equals(constraint1, (RequirementResourceConstraint)constraintIter2.next())) continue;
                foundEquals = true;
            }
            if (foundEquals) continue;
            return false;
        }
        return true;
    }
}

