/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.NameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.AlternativeRequirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;
import org.w3c.dom.Element;

public class AlternativeRequirementImpl extends NameableObject implements AlternativeRequirement {
	private static final String ALTERNATIVE_REQUIREMENT_TYPE = "sdd-dd:AlternativeRequirementType";
	
	public AlternativeRequirementImpl(Element data, SPISessionImpl session) {
		super(data, session, ALTERNATIVE_REQUIREMENT_TYPE);	
	}
	
	public String getAlternativeRequirementID() {
		return isSetAttribute("id") ? getAttribute("id") :  null;
	}

	public BigInteger getPriority() {
		return isSetAttribute("priority") ? new BigInteger(getAttribute("priority")) : null;
	}

	public Collection<RequirementResourceConstraint> getResourceConstraints() {
		Collection<Element> rrcElements = getChildren("ResourceConstraint");
		Collection<RequirementResourceConstraint> copiedResourceConstraintArray =
			new ArrayList<RequirementResourceConstraint>();
		
		for (Element element : rrcElements) {
			RequirementResourceConstraint constraint = new RequirementResourceConstraintImpl(element, session);
			copiedResourceConstraintArray.add(constraint);
		}
		
		return copiedResourceConstraintArray;
	}

	public void setResourceConstraints(Collection<RequirementResourceConstraint> newResourceConstraints) {
		if ((newResourceConstraints != null) && (!newResourceConstraints.isEmpty())) {
			removeContent(getChildren("ResourceConstraint", false));

            addContent(newResourceConstraints);
        }
		else {
        	unSetElement("ResourceConstraint");
        }
	}

	public void setAlternativeRequirementID(String alternativeRequirementID) {
		session.testParameter(alternativeRequirementID, 1, null);

		setAttribute("id", alternativeRequirementID);
	}

	public void setPriority(BigInteger priority) {
		if (priority == null) {
			unSetAttribute("priority");
		}
		else {
			setAttribute("priority", priority.toString());	
		}
	}

	public Object clone() {
		Element copiedElement = (Element) getElement().cloneNode(true);
		
		AlternativeRequirement duplicate = new AlternativeRequirementImpl(copiedElement, session);
		
		return duplicate;
	}
}