/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Properties;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.UniquenessConstraint;
import org.w3c.dom.Element;

public class UniquenessConstraint_Test extends TestCase {
    UniquenessConstraint uniquenessConstraint;
    UniquenessConstraint clonedUniquenessConstraint;
    Element element;
    SPISessionImpl session;
    
    public UniquenessConstraint_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        
        uniquenessConstraint = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createUniquenessConstraint("resourceRef");
        uniquenessConstraint.setDescription(new TranslatableString("unqDescription", "unqDescriptionKey"));
        uniquenessConstraint.setShortDescription(new TranslatableString("unqShortDescription", "unqShortDescriptionKey"));
        
        clonedUniquenessConstraint = (UniquenessConstraint)uniquenessConstraint.clone();
        element = ((SPIDataObject)uniquenessConstraint).getElement();
        session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        Properties props = uniquenessConstraint.getTranslatableStrings();
        Properties clonedProps = clonedUniquenessConstraint.getTranslatableStrings();
        
        assertEquals(2, props.keySet().size());
        assertEquals(2, clonedProps.keySet().size());
        
        assertEquals("unqDescription", props.get("unqDescriptionKey"));
        assertEquals("unqShortDescription", props.get("unqShortDescriptionKey"));

        assertEquals("unqDescription", clonedProps.get("unqDescriptionKey"));
        assertEquals("unqShortDescription", clonedProps.get("unqShortDescriptionKey"));
    }

    public void testGetDistinctResourceReference() {
        assertEquals("resourceRef", uniquenessConstraint.getDistinctResourceReference());
        assertEquals("resourceRef", clonedUniquenessConstraint.getDistinctResourceReference());
        assertEquals("resourceRef", element.getAttribute("distinctResourceRef"));
    }

    public void testSetDistinctResourceReference() {
        uniquenessConstraint.setDistinctResourceReference("differentRef");
        
        assertEquals("differentRef", uniquenessConstraint.getDistinctResourceReference());
        assertEquals("differentRef", ((SPIDataObject)uniquenessConstraint).getElement().getAttribute("distinctResourceRef"));
        
        try {
            uniquenessConstraint.setDistinctResourceReference(null);
            
            fail("DistinctResourceRef was set to null");
        }
        catch (Exception e) {
        }
    }

    public void testGetDescription() {
        assertEquals("unqDescription", uniquenessConstraint.getDescription().getValue());
        assertEquals("unqDescriptionKey", uniquenessConstraint.getDescription().getTranslationKey());

        assertEquals("unqDescription", uniquenessConstraint.getDescription().getValue());
        assertEquals("unqDescriptionKey", uniquenessConstraint.getDescription().getTranslationKey());
        
        assertEquals("unqDescription", session.getChildren(element, "Description").toArray(new Element[0])[0].getTextContent());
        assertEquals("unqDescriptionKey", (session.getChildren(element, "Description").toArray(new Element[0])[0]).getAttribute("translationKey"));
    }

    public void testGetShortDescription() {
        assertEquals("unqShortDescription", uniquenessConstraint.getShortDescription().getValue());
        assertEquals("unqShortDescriptionKey", uniquenessConstraint.getShortDescription().getTranslationKey());

        assertEquals("unqShortDescription", uniquenessConstraint.getShortDescription().getValue());
        assertEquals("unqShortDescriptionKey", uniquenessConstraint.getShortDescription().getTranslationKey());

        assertEquals("unqShortDescription", session.getChildren(element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        assertEquals("unqShortDescriptionKey", (session.getChildren(element, "ShortDescription").toArray(new Element[0])[0]).getAttribute("translationKey"));
    }

    public void testSetDescription() {
        uniquenessConstraint.setDescription(new TranslatableString("testSetDescription", "testSetDescriptionKey"));
        
        assertEquals("testSetDescription", uniquenessConstraint.getDescription().getValue());
        assertEquals("testSetDescription", session.getChildren(element, "Description").toArray(new Element[0])[0].getTextContent());
        assertEquals("testSetDescriptionKey", uniquenessConstraint.getDescription().getTranslationKey());
        assertEquals("testSetDescriptionKey", (session.getChildren(element, "Description").toArray(new Element[0])[0]).getAttribute("translationKey"));
    }

    public void testSetShortDescription() {
        uniquenessConstraint.setShortDescription(new TranslatableString("testSetShortDescription", "testSetShortDescriptionKey"));
        
        assertEquals("testSetShortDescription", uniquenessConstraint.getShortDescription().getValue());
        assertEquals("testSetShortDescription", session.getChildren(element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        assertEquals("testSetShortDescriptionKey", uniquenessConstraint.getShortDescription().getTranslationKey());
        assertEquals("testSetShortDescriptionKey", (session.getChildren(element, "ShortDescription").toArray(new Element[0])[0]).getAttribute("translationKey"));
    }
}