/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionAdminImpl;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionInfoImpl;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionSet;
import org.eclipse.osgi.framework.internal.core.FrameworkSecurityManager;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;

public class ConditionalPermissions
extends PermissionCollection {
    private static final long serialVersionUID = 3907215965749000496L;
    private AbstractBundle bundle;
    private Vector satisfiedCPIs = new Vector();
    private ConditionalPermissionSet satisfiedCPS;
    private Vector satisfiableCPSs = new Vector();
    private boolean empty;

    public ConditionalPermissions(AbstractBundle bundle, ConditionalPermissionAdmin cpa) {
        this.bundle = bundle;
        this.satisfiedCPS = new ConditionalPermissionSet(bundle, ConditionalPermissionAdminImpl.EMPTY_COND_PERM_INFO, ConditionalPermissionAdminImpl.EMPTY_COND);
        Enumeration en = cpa.getConditionalPermissionInfos();
        while (en.hasMoreElements()) {
            ConditionalPermissionInfoImpl cpi = (ConditionalPermissionInfoImpl)en.nextElement();
            this.checkConditionalPermissionInfo(cpi);
        }
    }

    void checkConditionalPermissionInfo(ConditionalPermissionInfoImpl cpi) {
        try {
            this.removeCPI(cpi);
            Condition[] conds = cpi.getConditions(this.bundle);
            if (conds == null) {
                return;
            }
            boolean satisfied = true;
            int i = 0;
            while (i < conds.length) {
                Condition cond = conds[i];
                if (cond.isMutable()) {
                    satisfied = false;
                } else {
                    if (!cond.isSatisfied()) {
                        return;
                    }
                    conds[i] = null;
                }
                ++i;
            }
            if (satisfied) {
                this.satisfiedCPIs.add(cpi);
            } else {
                this.satisfiableCPSs.add(new ConditionalPermissionSet(this.bundle, new ConditionalPermissionInfoImpl[]{cpi}, conds));
            }
        }
        catch (Exception e) {
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
        }
    }

    private void removeCPI(ConditionalPermissionInfoImpl cpi) {
        this.satisfiedCPIs.remove(cpi);
        this.satisfiedCPS.remove(cpi);
        ConditionalPermissionSet[] cpsArray = this.satisfiableCPSs.toArray(new ConditionalPermissionSet[0]);
        int i = 0;
        while (i < cpsArray.length) {
            if (cpsArray[i].remove(cpi)) {
                this.satisfiableCPSs.remove(cpsArray[i]);
            }
            ++i;
        }
    }

    public void add(Permission perm) {
    }

    public boolean implies(Permission perm) {
        boolean newEmpty;
        this.processPending();
        boolean bl = newEmpty = !this.satisfiedCPS.isNonEmpty();
        if (!newEmpty && this.satisfiedCPS.implies(perm)) {
            this.empty = false;
            return true;
        }
        boolean satisfied = false;
        Vector<Condition[]> unevalCondsSets = null;
        SecurityManager sm = System.getSecurityManager();
        FrameworkSecurityManager fsm = null;
        if (sm instanceof FrameworkSecurityManager) {
            fsm = (FrameworkSecurityManager)sm;
        }
        ConditionalPermissionSet[] cpsArray = this.satisfiableCPSs.toArray(new ConditionalPermissionSet[0]);
        int i = 0;
        while (i < cpsArray.length) {
            block15: {
                block16: {
                    if (!cpsArray[i].isNonEmpty()) break block16;
                    newEmpty = false;
                    Condition[] conds = cpsArray[i].getNeededConditions();
                    if (conds == null) break block15;
                    int j = 0;
                    while (j < conds.length) {
                        if (conds[j] == null || conds[j].isPostponed() || conds[j].isSatisfied()) {
                            ++j;
                            continue;
                        }
                        break block15;
                    }
                    if (!cpsArray[i].implies(perm)) break block15;
                    Vector<Condition> unevaluatedConds = null;
                    int j2 = 0;
                    while (j2 < conds.length) {
                        if (conds[j2] != null && conds[j2].isPostponed()) {
                            if (fsm == null) {
                                if (!conds[j2].isSatisfied()) {
                                    break block15;
                                }
                            } else {
                                if (unevaluatedConds == null) {
                                    unevaluatedConds = new Vector<Condition>();
                                }
                                unevaluatedConds.add(conds[j2]);
                            }
                        }
                        ++j2;
                    }
                    if (unevaluatedConds == null) {
                        this.empty = false;
                        return true;
                    }
                    if (unevalCondsSets == null) {
                        unevalCondsSets = new Vector<Condition[]>(2);
                    }
                    unevalCondsSets.add(unevaluatedConds.toArray(new Condition[unevaluatedConds.size()]));
                    satisfied = true;
                    break block15;
                }
                this.satisfiableCPSs.remove(cpsArray[i]);
            }
            ++i;
        }
        this.empty = newEmpty;
        if (satisfied && fsm != null) {
            Condition[][] condArray = (Condition[][])unevalCondsSets.toArray((T[])new Condition[unevalCondsSets.size()][]);
            satisfied = fsm.addConditionsForDomain(condArray);
        }
        return satisfied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPending() {
        if (this.satisfiedCPIs.size() > 0) {
            Vector vector = this.satisfiedCPIs;
            synchronized (vector) {
                int i = 0;
                while (i < this.satisfiedCPIs.size()) {
                    ConditionalPermissionInfoImpl cpi = (ConditionalPermissionInfoImpl)this.satisfiedCPIs.get(i);
                    if (!cpi.isDeleted()) {
                        this.satisfiedCPS.addConditionalPermissionInfo(cpi);
                    }
                    ++i;
                }
                this.satisfiedCPIs.clear();
            }
        }
    }

    public Enumeration elements() {
        return null;
    }

    boolean isEmpty() {
        return this.empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unresolvePermissions() {
        this.satisfiedCPS.unresolvePermissions();
        Vector vector = this.satisfiableCPSs;
        synchronized (vector) {
            Enumeration en = this.satisfiableCPSs.elements();
            while (en.hasMoreElements()) {
                ConditionalPermissionSet cs = (ConditionalPermissionSet)en.nextElement();
                cs.unresolvePermissions();
            }
        }
    }
}

