/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.util;

import java.io.InputStream;

/**
 * FileHelper provides file helper APIs 
 * @author sleeloy
 * @modified David Whiteman
 */
public class FileHelper {
	/**
	 * Returns an input stream for reading the specified resource.
	 *
	 * The search order is described in the documentation for {@link
	 * #getResource(String)}.<p>
	 *
	 * @param  name the resource name
	 * @return an input stream for reading the resource, or <code>null</code>
	 *         if the resource could not be found
	 */
	public static InputStream getResourceAsStream(String name) {
		ClassLoader clsLoader = FileHelper.class.getClassLoader();
		return clsLoader.getResourceAsStream(name);
	}
}
