/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.util;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Formatter;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionUtil {
    public static Properties getPropertiesFromPropertyElementList(Collection<Element> propertyElementList) {
        Properties p = new Properties();
        SPISessionImpl session = SPISessionImpl.getDefaultSession();
        if (propertyElementList != null) {
            for (Element propertyElement : propertyElementList) {
                Element propertyNameElement = session.getChild(propertyElement, "PropertyName");
                Element valueElement = session.getChild(propertyElement, "Value");
                String propertyName = null;
                String value = null;
                if (propertyNameElement != null) {
                    propertyName = propertyNameElement.getTextContent();
                }
                if (valueElement != null) {
                    value = valueElement.getTextContent();
                }
                if (propertyName == null || value == null) continue;
                p.put(propertyName, value);
            }
        }
        return p;
    }

    public static Properties dumpStrings(Node data) {
        Properties xStrings;
        block7: {
            block6: {
                xStrings = new Properties();
                if (!(data instanceof Document)) break block6;
                NodeList children = data.getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    Node child = children.item(i);
                    if (child instanceof Element) {
                        Properties props = ConversionUtil.dumpStrings((Element)children.item(i));
                        xStrings.putAll((Map<?, ?>)props);
                    }
                    ++i;
                }
                break block7;
            }
            if (!(data instanceof Element)) break block7;
            String translationKey = ((Element)data).getAttribute("translationKey");
            String value = data.getTextContent();
            if (translationKey != null && translationKey.length() > 0 && value != null && value.length() > 0) {
                xStrings.put(translationKey, value);
            } else {
                NodeList children = data.getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    Node child = children.item(i);
                    if (child instanceof Element) {
                        Properties props = ConversionUtil.dumpStrings((Element)children.item(i));
                        xStrings.putAll((Map<?, ?>)props);
                    }
                    ++i;
                }
            }
        }
        return xStrings;
    }

    public static String bytesToHex(byte[] bytes) {
        Formatter formatter = new Formatter();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            formatter.format("%02X", b);
            ++n2;
        }
        return formatter.toString();
    }

    public static byte[] hexToBytes(String hexString) {
        BigInteger bigInt = new BigInteger(hexString, 16);
        return bigInt.toByteArray();
    }
}

