/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.validation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.validation.util.ValidatorUtils;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.SDD_DAS;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.XMLValidationError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SDD_DASImpl extends XML_DASImpl implements SDD_DAS {
	// SDD Schema files
	private static final File commonSchema = ValidatorUtils.getTempFileFromSchemaName("sdd-common-1.0.xsd"); //$NON-NLS-1$
	private static final File ddSchema = ValidatorUtils.getTempFileFromSchemaName("sdd-deploymentDescriptor-1.0.xsd"); //$NON-NLS-1$
	private static final File pdSchema = ValidatorUtils.getTempFileFromSchemaName("sdd-packageDescriptor-1.0.xsd"); //$NON-NLS-1$
	private static final File xmldsigSchema = ValidatorUtils.getTempFileFromSchemaName("xmldsig-core-schema.xsd"); //$NON-NLS-1$
	private static final Collection<File> sddSchemaFiles = 
			Arrays.asList(new File[] {commonSchema, xmldsigSchema, pdSchema, ddSchema});
	// Descriptor root element names
	private static final String DD_ROOT_ELEMENT = "DeploymentDescriptor";
	private static final String PD_ROOT_ELEMENT = "PackageDescriptor"; 

	
	public SDD_DASImpl() {
		SchemaValidationRule validationRule = null;
		
		try {
			// Create a SchemaValidationRule containing the SDD Schema files
			validationRule = new SchemaValidationRule(sddSchemaFiles);
			
		} catch (FileNotFoundException e) {
			
		} catch (IOException e) {
			
		}
		
		// Add the ValidationRule if it was created successfully (i.e Schema files exist)
		if (validationRule != null) {
			addValidation(validationRule);	
		}
	}

	public Collection<XMLValidationError> validate(Document document) throws IllegalArgumentException {
		Element rootElement = document.getDocumentElement();
		
		// Determine the descriptor type and validate it
		if (ValidatorUtils.nodeNameEquals(rootElement, DD_ROOT_ELEMENT) ||
				ValidatorUtils.nodeNameEquals(rootElement, PD_ROOT_ELEMENT)) {
			return super.validate(document);
		}
		else {
			// Unknown descriptor type, throw an exception
			throw new IllegalArgumentException();
		}		
	}	
}