/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable;

import java.math.BigInteger;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariableExpression;
import org.w3c.dom.Element;

public class ConditionalDerivedVariableExpressionImpl extends SPIDataObject
		implements ConditionalDerivedVariableExpression {
	private static final String CONDITIONAL_DERIVED_VARIABLE_EXPRESSION_TYPE =
		"sdd-dd:ConditionalDerivedVariableExpressionType";

    public ConditionalDerivedVariableExpressionImpl(Element data, SPISessionImpl session) {
        super(data, session, CONDITIONAL_DERIVED_VARIABLE_EXPRESSION_TYPE);
    }
    
    public Condition getCondition() {
        Condition temp = new ConditionImpl(getChild("Condition"), session);
        return temp;
    }

    public String getExpression() {
        return getChild("Expression").getTextContent();
    }

    public BigInteger getPriority() {
    	return isSetAttribute("priority") ? new BigInteger(getAttribute("priority")) : null;
    	
    }
    
    public void setCondition(Condition newCondition) {
        session.testParameter(newCondition, 1, null);

        setContent(((SPIDataObject) newCondition).getElement());
    }

    public void setExpression(String expression) {
        session.testParameter(expression, 1, null);

        Element expressionElement = session.createDeploymentElement("Expression");
        expressionElement.setTextContent(expression);
		setContent(expressionElement);
    }

    public void setPriority(BigInteger priority) {
        if (priority == null) {
        	unSetAttribute("priority");
        }
        else {
            setAttribute("priority", priority.toString());
        }
    }

    public Object clone() {
        Element copy = (Element) getElement().cloneNode(true);
        ConditionalDerivedVariableExpressionImpl duplicate = new ConditionalDerivedVariableExpressionImpl(copy, session);
        
        return duplicate;
    }
}