/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.IntegerParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterBoundary;
import org.w3c.dom.Element;

public class IntegerParameterImpl extends ParameterImpl implements IntegerParameter {
	private static final String INTEGER_PARAMETER_TYPE = "sdd-dd:IntegerParameterType";

    public IntegerParameterImpl(Element data, SPISessionImpl session) {
        super(data, session, INTEGER_PARAMETER_TYPE);
    }
    
    public Collection<ParameterBoundary> getBounds() {
            
    	Collection<Element> boundaryElements = getChildren("Bounds");
    	Collection<ParameterBoundary> boundaryList = new ArrayList<ParameterBoundary>();
    		
    	for (Element element : boundaryElements) {
    		ParameterBoundaryImpl temp = new ParameterBoundaryImpl(element, session);
    		boundaryList.add(temp);
    	}
            
    	return boundaryList;
    }

    public void setBounds(Collection<ParameterBoundary> newBounds) {
    	session.testParameter(newBounds, 1, null);

    	removeContent(getChildren("Bounds", false));
    		    		
    	addContent(newBounds);		
    }

    public Object clone() {
    	Element copy = (Element) getElement().cloneNode(true);
    	IntegerParameterImpl duplicate = new IntegerParameterImpl(copy, session);

    	return duplicate;
    }
}
