/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Properties;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.w3c.dom.Element;

public class Language_Test extends TestCase
{
    Language lang;
    Language clonedLang;
    Element element;
    SPISessionImpl session;

    public Language_Test(String name)
    {
        super(name);
    }

    protected void setUp() throws Exception
    {
        super.setUp();
        lang = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("langType");
        
        lang.setDisplayName(new TranslatableString("displayName", "displayNameKey"));
        lang.setDescription(new TranslatableString("desc", "descKey"));
        lang.setShortDescription(new TranslatableString("shortDesc", "shortDescKey"));
        
        clonedLang = (Language) lang.clone();
        element = ((SPIDataObject) lang).getElement();
        session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings()
    {
        Properties props = lang.getTranslatableStrings();
        Properties clonedProps = clonedLang.getTranslatableStrings();
        
        assertEquals(3, props.keySet().size());
        assertEquals(3, clonedProps.keySet().size());
        
        assertEquals("desc", props.get("descKey"));
        assertEquals("shortDesc", props.get("shortDescKey"));
        assertEquals("displayName", props.get("displayNameKey"));
        
        assertEquals("desc", clonedProps.get("descKey"));
        assertEquals("shortDesc", clonedProps.get("shortDescKey"));
        assertEquals("displayName", clonedProps.get("displayNameKey"));
    }

    public void testGetType()
    {
        assertEquals("langType", lang.getType());
        assertEquals("langType", clonedLang.getType());
        assertEquals("langType", element.getAttribute("type"));
    }

    public void testGetDisplayName()
    {
        assertEquals("displayName", lang.getDisplayName().getValue());
        assertEquals("displayNameKey", lang.getDisplayName().getTranslationKey());

        assertEquals("displayName", clonedLang.getDisplayName().getValue());
        assertEquals("displayNameKey", clonedLang.getDisplayName().getTranslationKey());
        
        assertEquals("displayName", ( session.getChildren(element, "DisplayName").toArray(new Element[0])[0]).getTextContent());
        assertEquals("displayNameKey", ( session.getChildren(element, "DisplayName").toArray(new Element[0])[0]).getAttribute("translationKey"));
        		
    }

    public void testGetDescription()
    {
        assertEquals("desc", lang.getDescription().getValue());
        assertEquals("descKey", lang.getDescription().getTranslationKey());

        assertEquals("desc", clonedLang.getDescription().getValue());
        assertEquals("descKey", clonedLang.getDescription().getTranslationKey());
        
        assertEquals("desc", ( session.getChildren(element, "Description").toArray(new Element[0])[0]).getTextContent());
        assertEquals("descKey", ( session.getChildren(element, "Description").toArray(new Element[0])[0]).getAttribute("translationKey"));
    }

    public void testGetShortDescription()
    {
        assertEquals("shortDesc", lang.getShortDescription().getValue());
        assertEquals("shortDescKey", lang.getShortDescription().getTranslationKey());

        assertEquals("shortDesc", clonedLang.getShortDescription().getValue());
        assertEquals("shortDescKey", clonedLang.getShortDescription().getTranslationKey());
        
        assertEquals("shortDesc", ( session.getChildren(element, "ShortDescription").toArray(new Element[0])[0]).getTextContent());
        assertEquals("shortDescKey", ( session.getChildren(element, "ShortDescription").toArray(new Element[0])[0]).getAttribute("translationKey"));
    }

    public void testSetType()
    {
        lang.setType("differentType");
        
        assertEquals("differentType", lang.getType());
        assertEquals("differentType", element.getAttribute("type"));
        
        try
        {
            lang.setType(null);
            fail("Type set to null");
        }
        catch (Exception e)
        {
        }
    }

    public void testSetDisplayName()
    {
        lang.setDisplayName(new TranslatableString("differentName", "differentNameKey"));
        
        assertEquals("differentName", lang.getDisplayName().getValue());
        assertEquals("differentNameKey", lang.getDisplayName().getTranslationKey());

        assertEquals("differentName", ( session.getChildren(element, "DisplayName").toArray(new Element[0])[0]).getTextContent());
        assertEquals("differentNameKey", ( session.getChildren(element, "DisplayName").toArray(new Element[0])[0]).getAttribute("translationKey"));
    }

    public void testSetDescription()
    {
        lang.setDescription(new TranslatableString("differentDesc", "differentDescKey"));
        
        assertEquals("differentDesc", lang.getDescription().getValue());
        assertEquals("differentDescKey", lang.getDescription().getTranslationKey());

        assertEquals("differentDesc", ( session.getChildren(element, "Description").toArray(new Element[0])[0]).getTextContent());
        assertEquals("differentDescKey", ( session.getChildren(element, "Description").toArray(new Element[0])[0]).getAttribute("translationKey"));
    }

    public void testSetShortDescription()
    {
        lang.setShortDescription(new TranslatableString("differentShortDesc", "differentShortDescKey"));

        assertEquals("differentShortDesc", lang.getShortDescription().getValue());
        assertEquals("differentShortDescKey", lang.getShortDescription().getTranslationKey());

        assertEquals("differentShortDesc", ( session.getChildren(element, "ShortDescription").toArray(new Element[0])[0]).getTextContent());
        assertEquals("differentShortDescKey", ( session.getChildren(element, "ShortDescription").toArray(new Element[0])[0]).getAttribute("translationKey"));
    }
}
