/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition;

import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DisplayNameable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;


/**
 * When a condition can be met in more than one way, alternative sets of conditional resource constraints can be defined. 
 * AlternativeConditionalType provides the type definition for these elements.
 */
public interface AlternativeCondition extends DisplayNameable {
	
	/**
	 * Gets the alternative condition ID.
	 * 
	 * The id attribute may be useful to software that processes the SDD, for example, for use in creating log and trace messages.
	 * 
	 * @return Identifier for the alternative that is unique within the deployment descriptor.
	 */
	String getAlternativeConditionID();
	
	/**
	 * Gets the ConditionalResourceConstraints.
	 * 
	 * All constraints defined in the individual Alternative MUST be met for the Alternative condition to evaluate to true.
	 * 
	 * @return A collection of constraints on one resource. 
	 */
	Collection<ConditionalResourceConstraint> getConditionalResourceConstraints();
	
	/**
	 * Sets the alternative condition ID.
	 * 
	 * The id attribute may be useful to software that processes the SDD, for example, for use in creating log and trace messages.
	 * 
	 * @param id Identifier for the alternative that is unique within the deployment descriptor.
	 * @throws InvalidInputException if the parameter is null
	 */
	void setAlternativeConditionID(String id);

	/**
	 * Sets the ConditionalResourceConstraints.
	 * 
	 * All constraints defined in the individual Alternative MUST be met for the Alternative condition to evaluate to true.
	 * 
	 * @param crc A collection of constraints on one resource. 
	 * @throws InvalidInputException if any of the parameters is null
	 */
	void setConditionalResourceConstraints(Collection<ConditionalResourceConstraint> crc);

	/**
	 * Creates a copy of this object.
	 * 
	 * @return A copy of this object. 
	 */
	Object clone();
}
