/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement;

import java.util.Collection;

/**
 * A property value list is expressed as one or more strings representing valid values for the property. 
 */
public interface PropertyValueList {
	/**
	 * Determines whether the actual property value must match any or all of the listed values.
	 * 
	 * The value or values of the property found in the deployment environment are compared to the value or values listed in the 
	 * property constraint. PropertyMatchType defines two enumerated values: any and all. When match is set to any, the property 
	 * constraint is considered met when any one of the found property values matches any one of the declared property values. When 
	 * match is set to all, the constraint is considered met when all of the declared property values match values found for the 
	 * property.
	 * 
	 * @return Determines whether the actual property value must match any or all of the listed values.
	 */
	String getMatch();
	
	/**
	 * Gets the values.
	 * 
	 * The result of this variable expression represents one possible required value of the named resource property.
	 * 
	 * @return A collection of property values.
	 */
	Collection<String> getValue();
	
	/**
	 * Sets whether the actual property value must match any or all of the listed values.
	 * 
	 * The value or values of the property found in the deployment environment are compared to the value or values listed in the 
	 * property constraint. PropertyMatchType defines two enumerated values: any and all. When match is set to any, the property 
	 * constraint is considered met when any one of the found property values matches any one of the declared property values. When 
	 * match is set to all, the constraint is considered met when all of the declared property values match values found for the 
	 * property.
	 * 
	 * @param match Determines whether the actual property value must match any or all of the listed values.
	 * <ul>**default value=any</ul>
	 * 
	 */
	void setMatch(String match);
	    
	/**
	 * Sets the values.
	 * 
	 * The result of this variable expression represents one possible required value of the named resource property.
	 * 
	 * @param value A collection of property values.
	 */
	void setValue(Collection<String> value);
}
