/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig;

/**
 * 
 * When digest information is used to sign a content file, both the digest 
 * method and the digest value MUST be provided.
 *
 */
public interface Digest {
	/**
	 * Gets the digest method.
	 * 
	 * @return The digest method.
	 */
	DigestMethod getDigestMethod();
	
	/**
	 * Gets the digest value.
	 * 
	 * @return The digest value.
	 */
	byte[] getDigestValue();
	
	/**
	 * Sets the digest.
	 * 
	 * @param digestMethod The digest method to be used.
	 * @param digestValue The digest value to be use.
	 */
	void setDigest(DigestMethod digestMethod, byte[] digestValue);
}
