/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Represents a <record> element as specified in the CMDBf spec. These resources
 * encapsulate repository specific data for the instance.
 * 
 * 
 * @author David Whiteman
 */
public interface IRecord extends IXMLWritable 
{

	/**
	 * Answer the value for this record. The value contains the raw data for
	 * this instance.
	 * 
	 * @return
	 */
	public IXMLWritable getValue();

	
	/**
	 * Set the value for this record from a string.
	 * This API is needed because the value coming in
	 * from XML will be raw text.  Implementers are
	 * responsible for converting this raw text to
	 * their format of choice.
	 * 
	 * @param stringRepresentationOfValue
	 */
	public void setValueFromString(String stringRepresentationOfValue);
	
	
	/**
	 * Set the value for this record.
	 * 
	 * @param value
	 */
	public void setValue(IXMLWritable value);

	
	/**
	 * Add a namespace to be used in conjunction with any raw XML data returned
	 * by getValue()
	 * 
	 * @param namespacePrefix
	 * @param namespaceURI
	 */
	public void addNamespace(String namespacePrefix, String namespaceURI);
	
	
	/**
	 * Returns the record metadata
	 * 
	 * @return The record metadata
	 */
	public IRecordMetadata getRecordMetadata();
	
	
	/**
	 * Sets the metadata for this record
	 * 
	 * @param recordMetadata The record metadata
	 */
	public void setRecordMetadata(IRecordMetadata recordMetadata);
}
