/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.o10r.impl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.eclipse.cosmos.me.sdd.cr.Constraint;
import org.eclipse.cosmos.me.sdd.cr.ResolverByQname;
import org.eclipse.cosmos.me.sdd.schema.CapacityConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConditionalPropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConditionalResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConsumptionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConsumptionConstraintValueType;
import org.eclipse.cosmos.me.sdd.schema.MaxVersionType;
import org.eclipse.cosmos.me.sdd.schema.PropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.PropertyValueListType;
import org.eclipse.cosmos.me.sdd.schema.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.VersionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.VersionConstraintValueType;
import org.eclipse.cosmos.me.sdd.schema.VersionRangeType;
import org.eclipse.cosmos.me.sdd.schema.VersionValueType;
import org.eclipse.cosmos.me.sdd.schema.ext.ResolutionObject;

public class ResourceConstraintResolver {
    private ResolverByQname _resolver;

    public ResourceConstraintResolver(ResolverByQname r) {
        this._resolver = r;
    }

    public ResolutionObject resolve(RequirementResourceConstraintType constraint, ResolutionObject resolution) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (Object type : constraint.getResourceConstraintGroup()) {
            Constraint c = new Constraint();
            Object constraintType = ((JAXBElement)type).getValue();
            if (constraintType instanceof VersionConstraintType) {
                VersionConstraintType versionConstraint = (VersionConstraintType)constraintType;
                c.setType("version");
                VersionConstraintValueType supported = versionConstraint.getSupported();
                if (supported != null) {
                    for (VersionRangeType range : supported.getRange()) {
                        MaxVersionType maxType;
                        if (range != null) {
                            String minimumValue = range.getMinVersion();
                            c.setValue("minimum", minimumValue);
                        }
                        if ((maxType = range.getMaxVersion()) == null) continue;
                        String maximumValue = maxType.getValue();
                        c.setValue("maximum", maximumValue);
                    }
                    for (VersionValueType version : supported.getValue()) {
                        c.setValue("versionvalue", version.getVersion());
                    }
                }
            } else if (constraintType instanceof CapacityConstraintType) {
                c.setType("capacity");
            } else if (constraintType instanceof PropertyConstraintType) {
                List valuesList;
                PropertyConstraintType propertyConstraint = (PropertyConstraintType)constraintType;
                c.setType("property");
                String name = propertyConstraint.getPropertyName().getLocalPart();
                PropertyValueListType propertyValues = propertyConstraint.getListOfValues();
                if (propertyValues != null && (valuesList = propertyValues.getValue()) != null) {
                    String[] values = (String[])valuesList.toArray();
                    c.setValues(name, values);
                }
                String value = propertyConstraint.getValue();
                c.setValue(name, value);
            } else if (constraintType instanceof ConsumptionConstraintType) {
                ConsumptionConstraintType consumptionConstraint = (ConsumptionConstraintType)constraintType;
                c.setType("consumption");
                String consumptionName = consumptionConstraint.getPropertyName().getLocalPart();
                ConsumptionConstraintValueType consumptionValue = consumptionConstraint.getValue();
                if (consumptionValue != null) {
                    c.setValue(consumptionName, consumptionValue.getValue());
                }
            } else {
                System.out.println("Tell us what you are '" + constraintType.toString() + "'");
            }
            if (c.getType() != null) {
                c.setResource(resolution.getValue());
                this._resolver.resolve(this.getResource(constraint).getType(), c);
                constraints.add(c);
                continue;
            }
            System.out.println("Unable to find the type of constraint we were looking for...");
        }
        boolean resourceResolved = true;
        for (Constraint c : constraints) {
            if (!c.isRejected()) continue;
            resourceResolved = false;
        }
        if (resourceResolved) {
            resolution.resolve();
        } else {
            resolution.reject();
        }
        return resolution;
    }

    public ResolutionObject resolve(ConditionalResourceConstraintType constraint, ResolutionObject resolution) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (ConditionalPropertyConstraintType propertyConstraint : constraint.getPropertyConstraint()) {
            String value;
            List valuesList;
            Constraint c = new Constraint();
            c.setType("property");
            String name = propertyConstraint.getPropertyName().getLocalPart();
            PropertyValueListType propertyValues = propertyConstraint.getListOfValues();
            if (propertyValues != null && !(valuesList = propertyValues.getValue()).isEmpty()) {
                ArrayList<String> l = new ArrayList<String>();
                for (JAXBElement j : valuesList) {
                    l.add((String)j.getValue());
                }
                c.setValues(name, l.toArray(new String[0]));
            }
            if ((value = propertyConstraint.getValue()) != null) {
                c.setValue(name, value);
            }
            if (c.getType() != null) {
                this._resolver.resolve(this.getResource(constraint).getType(), c);
                constraints.add(c);
                continue;
            }
            System.out.println("Unable to find the type of constraint we were looking for...");
        }
        boolean resourceResolved = true;
        for (Constraint c : constraints) {
            if (!c.isRejected()) continue;
            resourceResolved = false;
        }
        if (resourceResolved) {
            resolution.resolve();
        } else {
            resolution.reject();
        }
        return resolution;
    }

    private ResourceType getResource(RequirementResourceConstraintType rrct) {
        return (ResourceType)rrct.getResourceRef();
    }

    private ResourceType getResource(ConditionalResourceConstraintType rrct) {
        return (ResourceType)rrct.getResourceRef();
    }
}

