/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.cim.profile;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.eclipse.cosmos.me.sdd.cr.Constraint;
import org.eclipse.cosmos.me.sdd.cr.IResolver;
import org.eclipse.cosmos.me.sdd.schema.ext.ResolutionObject;

public class FileSystemResolver
implements IResolver {
    public ResolutionObject resolve(Constraint c) {
        ResolutionObject resolution = new ResolutionObject();
        if (c.getType().equalsIgnoreCase("property")) {
            return this.resolveProperty(c, resolution);
        }
        if (c.getType().equalsIgnoreCase("version")) {
            return this.resolveVersion(c, resolution);
        }
        if (c.getType().equalsIgnoreCase("capacity")) {
            return this.resolveCapacity(c, resolution);
        }
        if (c.getType().equalsIgnoreCase("consumption")) {
            return this.resolveConsumption(c, resolution);
        }
        return resolution;
    }

    private ResolutionObject resolveConsumption(Constraint c, ResolutionObject resolution) {
        for (String name : c.getNames()) {
            if (!name.endsWith("AvailableSpace")) continue;
            return this.resolveFileSystemAvailableSpace(name, c, resolution);
        }
        return resolution;
    }

    private ResolutionObject resolveCapacity(Constraint c, ResolutionObject resolution) {
        System.out.println("FileSystemResolver.resolveCapacity() - not implemented.");
        return resolution;
    }

    private ResolutionObject resolveVersion(Constraint c, ResolutionObject resolution) {
        System.out.println("FileSystemResolver.resolveVersion() - not implemented.");
        return resolution;
    }

    private ResolutionObject resolveProperty(Constraint c, ResolutionObject resolution) {
        System.out.println("FileSystemResolver.resolveProperty() - not implemented.");
        return resolution;
    }

    private ResolutionObject resolveFileSystemAvailableSpace(String name, Constraint c, ResolutionObject resolution) {
        String directory = c.getResource();
        File f = new File(directory);
        if (f.exists() && f.isDirectory()) {
            String[] values = c.getValues("CIM_FileSystem.AvailableSpace");
            long requestedSize = Long.parseLong(values[0]);
            long freeSpace = this.getFreeSpace(directory);
            if (freeSpace > (requestedSize *= 512L)) {
                resolution.accept();
                c.accept();
            } else {
                resolution.reject();
                c.reject();
            }
        }
        return resolution;
    }

    private long getFreeSpace(String directoryName) {
        Process process;
        String os;
        block5: {
            os = System.getProperty("os.name");
            String command = os.contains("Windows") ? "cmd.exe /c dir \"" + directoryName + "\"" : "df " + directoryName;
            Runtime runtime = Runtime.getRuntime();
            process = runtime.exec(command);
            if (process != null) break block5;
            return 0L;
        }
        try {
            BufferedReader inStream = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            String output = null;
            while ((line = inStream.readLine()) != null) {
                output = line;
            }
            if (os.contains("Windows")) {
                return this.windowsFreeSpace(output);
            }
            return this.unixFreeSpace(output);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private long unixFreeSpace(String output) {
        if (output != null) {
            String availableSpace = output.trim();
            StringTokenizer outputTokens = new StringTokenizer(output, ":");
            outputTokens.nextToken();
            availableSpace = outputTokens.nextToken();
            String[] tokens = availableSpace.split(" ");
            int idx = 1;
            if (idx < tokens.length) {
                try {
                    long total = Long.parseLong(tokens[idx++].trim());
                    return total;
                }
                catch (NumberFormatException numberFormatException) {
                    return 0L;
                }
            }
        }
        return 0L;
    }

    private long windowsFreeSpace(String output) {
        if (output != null) {
            String availableSpace = output.trim();
            availableSpace = availableSpace.replaceAll("\\.", "");
            availableSpace = availableSpace.replaceAll(",", "");
            String[] tokens = availableSpace.split(" ");
            int idx = 1;
            while (idx < tokens.length) {
                try {
                    long total = Long.parseLong(tokens[idx++]);
                    return total;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return 0L;
    }
}

