/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.o10r.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.eclipse.cosmos.me.sdd.cr.ResolverByQname;
import org.eclipse.cosmos.me.sdd.o10r.impl.ResourceConstraintResolver;
import org.eclipse.cosmos.me.sdd.schema.AdditionalContentType;
import org.eclipse.cosmos.me.sdd.schema.AlternativeRequirementType;
import org.eclipse.cosmos.me.sdd.schema.ArgumentType;
import org.eclipse.cosmos.me.sdd.schema.BooleanParameterType;
import org.eclipse.cosmos.me.sdd.schema.ConditionType;
import org.eclipse.cosmos.me.sdd.schema.ConditionalDerivedVariableExpressionType;
import org.eclipse.cosmos.me.sdd.schema.ConditionalResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ContentType;
import org.eclipse.cosmos.me.sdd.schema.DerivedVariableType;
import org.eclipse.cosmos.me.sdd.schema.InstallableUnitType;
import org.eclipse.cosmos.me.sdd.schema.IntegerParameterType;
import org.eclipse.cosmos.me.sdd.schema.ParametersType;
import org.eclipse.cosmos.me.sdd.schema.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.RequirementType;
import org.eclipse.cosmos.me.sdd.schema.RequirementsType;
import org.eclipse.cosmos.me.sdd.schema.ResourcePropertyType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.ResultingResourceType;
import org.eclipse.cosmos.me.sdd.schema.SubstitutionType;
import org.eclipse.cosmos.me.sdd.schema.URIParameterType;
import org.eclipse.cosmos.me.sdd.schema.VariablesType;
import org.eclipse.cosmos.me.sdd.schema.ext.ResolutionObject;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public class InstallableUnitWalker {
    SDDContext _ctxt;
    ResourceConstraintResolver _resourceResolver;

    public InstallableUnitWalker(SDDContext ctxt, ResolverByQname resolver) {
        this._ctxt = ctxt;
        this._resourceResolver = new ResourceConstraintResolver(resolver);
    }

    public void walk(ResourceType resource) {
        RequirementsType requirements;
        InstallableUnitType iu = this._ctxt.getDeploymentDescriptor().getInstallableUnit();
        VariablesType variables = iu.getVariables();
        if (variables != null) {
            for (Object listObject : variables.getParametersOrResourcePropertyOrDerivedVariable()) {
                this.walkVariable(listObject);
            }
        }
        if ((requirements = iu.getRequirements()) != null) {
            for (RequirementType requirement : requirements.getRequirement()) {
                this.walkRequirement(requirement);
            }
        }
        for (ResultingResourceType resultingResource : iu.getResultingResource()) {
            this.walkResultingResource(resultingResource);
        }
        if (iu.getArtifacts().getInstallArtifact() != null) {
            this.walkInstallableUnit(iu);
        }
    }

    private void walkVariable(Object type) {
        try {
            ((JAXBElement)type).getValue();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        Object listObject = ((JAXBElement)type).getValue();
        if (listObject instanceof DerivedVariableType) {
            DerivedVariableType derivedType = (DerivedVariableType)listObject;
            ArrayList<ResolutionObject> resolutionList = new ArrayList<ResolutionObject>();
            for (ConditionalDerivedVariableExpressionType conditionalType : derivedType.getConditionalExpression()) {
                ResolutionObject resolution = new ResolutionObject();
                ConditionType condition = conditionalType.getCondition();
                if (condition == null) continue;
                String expression = conditionalType.getExpression();
                resolution.setValue(expression);
                List conditionalConstraintList = condition.getResourceConstraint();
                for (ConditionalResourceConstraintType c : conditionalConstraintList) {
                    resolutionList.add(this._resourceResolver.resolve(c, resolution));
                }
            }
            for (ResolutionObject r : resolutionList) {
                if (!r.isResolved()) continue;
                r.setId(derivedType.getId());
                this._ctxt.getResolutionModel().addResolutionObject(derivedType.getId(), r);
            }
        } else if (listObject instanceof ResourcePropertyType) {
            ResourcePropertyType resourceType = (ResourcePropertyType)listObject;
            System.out.println("ResourcePropertyType for variables are not implemented...." + resourceType.getId());
        } else if (listObject instanceof ParametersType) {
            ParametersType parametersType = (ParametersType)listObject;
            List parametersList = parametersType.getIntegerParameterOrStringParameterOrBooleanParameter();
            for (Object param : parametersList) {
                ResolutionObject resolution = new ResolutionObject();
                Object parameterObject = ((JAXBElement)param).getValue();
                if (parameterObject instanceof URIParameterType) {
                    URIParameterType uiParameter = (URIParameterType)parameterObject;
                    resolution.setId(uiParameter.getId());
                    resolution.setValue(uiParameter.getDefaultValue());
                } else if (parameterObject instanceof IntegerParameterType) {
                    IntegerParameterType integerParameter = (IntegerParameterType)parameterObject;
                    resolution.setId(integerParameter.getId());
                    resolution.setValue(integerParameter.getDefaultValue());
                } else if (parameterObject instanceof BooleanParameterType) {
                    BooleanParameterType booleanParameter = (BooleanParameterType)parameterObject;
                    resolution.setId(booleanParameter.getId());
                    resolution.setValue(booleanParameter.getDefaultValue());
                } else {
                    System.out.println("walkVariables() - Don't know this parameter type" + parameterObject.toString());
                }
                if (resolution.getValue() != null) {
                    String resolutionValue = resolution.getValue();
                    String envValue = this.resolveEnvironmentVariable(resolutionValue);
                    ResolutionObject resolved = this._ctxt.getResolutionModel().getResolutionObject(envValue);
                    if (resolved != null) {
                        String resolvedParameterValue = resolved.getValue();
                        resolutionValue = resolutionValue.replace("$(" + envValue + ")", resolvedParameterValue);
                        resolution.setValue(resolutionValue);
                        resolution.resolve();
                    }
                }
                this._ctxt.getResolutionModel().addResolutionObject(resolution.getId(), resolution);
            }
        } else {
            System.out.println("walkVariables() - Don't know this variable type" + listObject.toString());
        }
    }

    private void walkRequirement(RequirementType requirement) {
        for (AlternativeRequirementType alternative : requirement.getAlternative()) {
            for (RequirementResourceConstraintType resourceConstraint : alternative.getResourceConstraint()) {
                ResolutionObject resolution = new ResolutionObject();
                resolution.setId(resourceConstraint.getId());
                ResourceType type = (ResourceType)resourceConstraint.getResourceRef();
                resolution.setReferenceId(type.getId());
                resolution.setValue(type.getName());
                String resourceName = type.getName();
                if (resourceName != null) {
                    String value = this.resolveEnvironmentVariable(resourceName);
                    ResolutionObject resolved = this._ctxt.getResolutionModel().getResolutionObject(value);
                    if (resolved != null) {
                        String resolvedParameterValue = resolved.getValue();
                        value = resourceName.replace("$(" + value + ")", resolvedParameterValue);
                        resolution.setValue(value);
                    }
                }
                this._ctxt.getResolutionModel().addResolutionObject(resourceConstraint.getId(), this._resourceResolver.resolve(resourceConstraint, resolution));
            }
        }
        for (RequirementResourceConstraintType resourceConstraint : requirement.getResourceConstraint()) {
            ResolutionObject resolution = new ResolutionObject();
            resolution.setId(resourceConstraint.getId());
            ResourceType type = (ResourceType)resourceConstraint.getResourceRef();
            resolution.setReferenceId(type.getId());
            String resourceName = type.getName();
            if (resourceName != null) {
                String value = this.resolveEnvironmentVariable(resourceName);
                ResolutionObject resolved = this._ctxt.getResolutionModel().getResolutionObject(value);
                if (resolved != null) {
                    String resolvedParameterValue = resolved.getValue();
                    value = resourceName.replace("$(" + value + ")", resolvedParameterValue);
                    resolution.setValue(value);
                }
            }
            this._ctxt.getResolutionModel().addResolutionObject(resourceConstraint.getId(), this._resourceResolver.resolve(resourceConstraint, resolution));
        }
    }

    private void walkResultingResource(ResultingResourceType resultingResource) {
        ResolutionObject obj = new ResolutionObject();
        obj.setReferenceId(((ResourceType)resultingResource.getResourceRef()).getId());
        obj.setId(resultingResource.getName());
        obj.setValue(resultingResource.getVersion());
        obj.resolve();
        this._ctxt.getResolutionModel().addResultingResource(obj.getReferenceId(), obj);
    }

    private void walkInstallableUnit(InstallableUnitType iu) {
        int i = 0;
        for (ArgumentType argument : iu.getArtifacts().getInstallArtifact().getArguments().getArgument()) {
            ResolutionObject obj = new ResolutionObject();
            obj.setId(argument.getName());
            String resolutionValue = argument.getValue();
            String envValue = this.resolveEnvironmentVariable(resolutionValue);
            ResolutionObject resolved = this._ctxt.getResolutionModel().getResolutionObject(envValue);
            if (resolved != null) {
                String resolvedParameterValue = resolved.getValue();
                resolutionValue = resolutionValue.replace("$(" + envValue + ")", resolvedParameterValue);
                obj.setValue(resolutionValue);
                obj.resolve();
            }
            this._ctxt.getResolutionModel().addArtifact("argument_" + i++, obj);
        }
        for (AdditionalContentType additionalContent : iu.getArtifacts().getInstallArtifact().getAdditionalContent()) {
            String contentReference = additionalContent.getContentRef();
            String contentName = null;
            List packageFileArray = this._ctxt.getPackageDescriptor().getContents().getContent();
            for (ContentType packageContent : packageFileArray) {
                if (!contentReference.equalsIgnoreCase(packageContent.getId())) continue;
                contentName = packageContent.getPathname();
            }
            ResolutionObject contentResolution = new ResolutionObject();
            contentResolution.setReferenceId(contentName);
            List substitutionList = additionalContent.getSubstitution();
            int v = 0;
            for (SubstitutionType substitution : substitutionList) {
                ResolutionObject obj = new ResolutionObject();
                obj.setReferenceId(contentName);
                obj.setId(substitution.getPattern());
                String resolutionValue = substitution.getValue();
                String envValue = this.resolveEnvironmentVariable(resolutionValue);
                ResolutionObject resolved = this._ctxt.getResolutionModel().getResolutionObject(envValue);
                if (resolved != null) {
                    String resolvedParameterValue = resolved.getValue();
                    resolutionValue = resolutionValue.replace("$(" + envValue + ")", resolvedParameterValue);
                    obj.setValue(resolutionValue);
                    obj.resolve();
                }
                this._ctxt.getResolutionModel().addArtifact("substitution_" + v++, obj);
                String parentDir = this._ctxt.getPackageDescriptorParentUri();
                File f = new File(String.valueOf(parentDir) + File.separator + "additionalcontent" + File.separator + contentName);
                if (!f.exists()) continue;
                BufferedReader reader = null;
                BufferedWriter writer = null;
                try {
                    String line;
                    reader = new BufferedReader(new FileReader(f));
                    StringBuffer buffer = new StringBuffer();
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line.replace(obj.getId(), obj.getValue())).append("\n");
                    }
                    reader.close();
                    writer = new BufferedWriter(new FileWriter(f));
                    writer.write(buffer.toString());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        try {
                            writer.close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String resolveEnvironmentVariable(String value) {
        String envValue = value;
        if (envValue.contains("$")) {
            envValue = value.substring(value.indexOf("$"), value.indexOf(")") + 1);
            envValue = envValue.replace("$", "");
            envValue = envValue.replace("(", "");
            envValue = envValue.replace(")", "");
        }
        return envValue;
    }
}

