/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.o10r.impl;

import org.eclipse.cosmos.me.sdd.cr.ResourceHandler;
import org.eclipse.cosmos.me.sdd.o10r.Orchestrator;
import org.eclipse.cosmos.me.sdd.o10r.impl.RequirementsResolver;
import org.eclipse.cosmos.me.sdd.o10r.impl.SddContextImpl;
import org.eclipse.cosmos.me.sdd.o10r.impl.VariableResolver;
import org.eclipse.cosmos.me.sdd.op.OperationHandler;
import org.eclipse.cosmos.me.sdd.schema.AdditionalContentType;
import org.eclipse.cosmos.me.sdd.schema.ArtifactType;
import org.eclipse.cosmos.me.sdd.schema.DeploymentDescriptorType;
import org.eclipse.cosmos.me.sdd.schema.InstallableUnitType;
import org.eclipse.cosmos.me.sdd.schema.InstallationArtifactsType;
import org.eclipse.cosmos.me.sdd.schema.OperationType;
import org.eclipse.cosmos.me.sdd.schema.PackageDescriptorType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;
import org.eclipse.cosmos.me.sdd.schema.marshal.Marshaller;

public class OrchestratorImpl
implements Orchestrator {
    private Marshaller marshaller;
    private OperationHandler ophandler;
    private ResourceHandler rsrcHandler;

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void unsetMarshaller(Marshaller marshaller) {
        this.marshaller = null;
    }

    public void setOperationHandlerByType(OperationHandler ophandler) {
        this.ophandler = ophandler;
    }

    public void unsetOperationHandlerByType(OperationHandler ophandler) {
        this.ophandler = null;
    }

    public void setResourceHandler(ResourceHandler rsrcHandler) {
        this.rsrcHandler = rsrcHandler;
    }

    public void unsetResourceHandler(ResourceHandler rsrcHandler) {
        this.rsrcHandler = null;
    }

    public void deploy(String packageUri, String operation) {
        OperationType op = OperationType.fromValue((String)operation);
        switch (op) {
            case INSTALL: 
            case UNINSTALL: {
                this.installableUnit(packageUri, op);
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void installableUnit(String packageUri, OperationType op) {
        DeploymentDescriptorType dd;
        SddContextImpl ctxt = new SddContextImpl(this.marshaller, packageUri);
        PackageDescriptorType pd = ctxt.getPackageDescriptor();
        if (pd == null || (dd = ctxt.getDeploymentDescriptor()) == null) return;
        new VariableResolver(ctxt, this.rsrcHandler).installableUnitResolver();
        RequirementsResolver reqResolver = new RequirementsResolver(ctxt, this.rsrcHandler);
        if (reqResolver.installableUnitResolver()) {
            InstallableUnitType unit = dd.getInstallableUnit();
            if (unit == null || unit.getArtifacts() == null) return;
            InstallationArtifactsType artifacts = unit.getArtifacts();
            switch (op) {
                case INSTALL: {
                    if (artifacts.getInstallArtifact() == null) return;
                    ArtifactType artifact = artifacts.getInstallArtifact();
                    this.ophandler.invokeAction((SDDContext)ctxt, artifact, op);
                    for (AdditionalContentType c : artifact.getAdditionalContent()) {
                        this.ophandler.invokeAction((SDDContext)ctxt, artifact, c, op);
                    }
                    return;
                }
                case UNINSTALL: {
                    if (artifacts.getUninstallArtifact() == null) return;
                    this.ophandler.invokeAction((SDDContext)ctxt, artifacts.getUninstallArtifact(), op);
                }
                default: {
                    return;
                }
            }
        }
        System.out.println("Requirements are not met...");
    }
}

