/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.o10r.impl;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.me.sdd.cr.ResourceHandler;
import org.eclipse.cosmos.me.sdd.schema.AlternativeRequirementType;
import org.eclipse.cosmos.me.sdd.schema.ConsumptionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.InstallableUnitType;
import org.eclipse.cosmos.me.sdd.schema.PropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.RequirementType;
import org.eclipse.cosmos.me.sdd.schema.RequirementsType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.VersionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public class RequirementsResolver {
    private SDDContext ctxt;
    private ResourceHandler handler;

    public RequirementsResolver(SDDContext ctxt, ResourceHandler handler) {
        this.ctxt = ctxt;
        this.handler = handler;
    }

    public boolean installableUnitResolver() {
        InstallableUnitType iu = this.ctxt.getDeploymentDescriptor().getInstallableUnit();
        return this.resolve(iu.getRequirements());
    }

    private boolean resolve(RequirementsType requirements) {
        boolean result = true;
        if (requirements != null) {
            for (RequirementType req : requirements.getRequirement()) {
                boolean bl = result = result && this.resolve(req);
            }
        }
        return result;
    }

    private boolean resolve(RequirementType requirement) {
        boolean result = true;
        if (!requirement.getAlternative().isEmpty()) {
            boolean altResult = false;
            for (AlternativeRequirementType req : requirement.getAlternative()) {
                boolean bl = altResult = altResult || this.resolve(req);
            }
            result = result && altResult;
        }
        for (RequirementResourceConstraintType req : requirement.getResourceConstraint()) {
            boolean bl = result = result && this.resolve(req);
        }
        return result;
    }

    private boolean resolve(AlternativeRequirementType requirement) {
        boolean result = true;
        for (RequirementResourceConstraintType req : requirement.getResourceConstraint()) {
            boolean bl = result = result && this.resolve(req);
        }
        return result;
    }

    private boolean resolve(RequirementResourceConstraintType requirement) {
        boolean result = true;
        ResourceType rsrc = (ResourceType)requirement.getResourceRef();
        for (Object o : requirement.getResourceConstraintGroup()) {
            if (!(o instanceof JAXBElement)) continue;
            Object value = ((JAXBElement)o).getValue();
            if (value instanceof PropertyConstraintType) {
                result = result && this.resolve(rsrc, (PropertyConstraintType)value);
                continue;
            }
            if (value instanceof ConsumptionConstraintType) {
                result = result && this.resolve(rsrc, (ConsumptionConstraintType)value);
                continue;
            }
            if (!(value instanceof VersionConstraintType)) continue;
            boolean bl = result = result && this.resolve(rsrc, (VersionConstraintType)value);
        }
        if (result) {
            requirement.getOtherAttributes().put(new QName("satisfied"), "true");
        }
        return result;
    }

    private boolean resolve(ResourceType rsrc, VersionConstraintType constraint) {
        boolean result = this.handler.evaluate(this.ctxt, rsrc, constraint);
        return result;
    }

    private boolean resolve(ResourceType rsrc, PropertyConstraintType constraint) {
        boolean result = this.handler.evaluate(this.ctxt, rsrc, constraint);
        return result;
    }

    private boolean resolve(ResourceType rsrc, ConsumptionConstraintType constraint) {
        boolean result = this.handler.evaluate(this.ctxt, rsrc, constraint);
        Long value = (Long)this.handler.getPropertyValue(this.ctxt, rsrc, constraint.getPropertyName());
        constraint.getValue().getOtherAttributes().put(new QName("actual"), value.toString());
        return result;
    }
}

