/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.cim.profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    protected final String[] part;

    public Version(String version) {
        this.part = version.split("\\.");
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.part.length > 0) {
            int i = 0;
            s.append(this.part[i++]);
            while (i < this.part.length) {
                s.append(".").append(this.part[i]);
                ++i;
            }
        }
        return s.toString();
    }

    @Override
    public int compareTo(Version v) {
        if (v == null) {
            throw new IllegalArgumentException();
        }
        int ia = this.part.length;
        int ib = v.part.length;
        int limit = Math.min(ia, ib);
        int i = 0;
        while (i < limit) {
            String a = this.part[i];
            String b = v.part[i];
            int c = this.compare(a, b);
            if (c != 0) {
                return c;
            }
            ++i;
        }
        if (ia > ib) {
            return 1;
        }
        if (ia < ib) {
            return -1;
        }
        return 0;
    }

    private int compare(String a, String b) {
        try {
            Float af = Float.valueOf(a);
            Float bf = Float.valueOf(b);
            return af.compareTo(bf);
        }
        catch (NumberFormatException numberFormatException) {
            return a.compareTo(b);
        }
    }
}

