/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.schema.ext;

import java.io.InputStream;
import java.util.List;

import org.eclipse.cosmos.me.sdd.schema.ContentType;
import org.eclipse.cosmos.me.sdd.schema.DeploymentDescriptorType;
import org.eclipse.cosmos.me.sdd.schema.PackageDescriptorType;

public interface SDDContext {

	public PackageDescriptorType getPackageDescriptor();
	public void setPackageDescriptor(String packageUri);

	public String getPackageDescriptorParentUri();

	public DeploymentDescriptorType getDeploymentDescriptor();

	public void setVariable( String variable, String value );
	public String getVariable( String variable );
	
	public boolean containsVariable(String variable);
	public String substituteVariables( String expression );
	
	public Variables getVariables();
	public void setParameter(String id, Boolean required, String defaultValue);
	
	public ContentType getContentById(String id);
	public List<ContentType> getContentByPurpose(String purpose);

	public InputStream getInputStreamForPath(String path);
	
	public ResolutionModel getResolutionModel();
}