/***********************************************************************
 * Copyright (c) 2008 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - CQ 2316
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.schema.marshal.impl;

import java.util.HashMap;
import java.util.Map;

public enum NSPrefix {
	XSI("xsi", "http://www.w3.org/2001/XMLSchema-instance"),
	FLATTENED("flattened", "http://www.schema.changeanalyzer.sdd.ibm.com/Logicalresoucecombination"),
	ANALYZED("analyzed", "http://www.schema.changeanalyzer.sdd.ibm.com/analyzedsdd"),
	STATIC("static", "http://www.schema.changeanalyzer.sdd.ibm.com/staticoutput"),
	SDD_DD("sdd-dd", "http://docs.oasis-open.org/sdd/ns/deploymentDescriptor"),
	SDD_PD("sdd-pd", "http://docs.oasis-open.org/sdd/ns/packageDescriptor"),
	SDD_COMMON("sdd-common", "http://docs.oasis-open.org/sdd/ns/common"),
	DS("ds", "http://www.w3.org/2000/09/xmldsig#"),
	SP("sp", "http://docs.oasis-open.org/sdd/ns/starterProfile"),
	CP("cp", "http://docs.oasis-open.org/sdd/ns/cim-profile"),
	EXT("ext", "http://cosmos.eclipse.org/me/sdd/ext");
	
	private final String namespace;
	private final String prefix;
	
	private static final Map<String, NSPrefix> stringToEnum = new HashMap<String, NSPrefix>();
	
	static {
		for (NSPrefix np : values()) {
			stringToEnum.put(np.namespace, np);
		}
	}
	
	public static NSPrefix fromString(String namespace) {
		return stringToEnum.get(namespace);
	}
	
	NSPrefix(String prefix, String namespace) {
		this.prefix = prefix;
		this.namespace = namespace;
	}
	
	public String prefix() {
		return prefix;
	}
	
	public String namespace() {
		return namespace;
	}
	
	@Override
	public String toString() {
		return namespace();
	}
}
