/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.cr;

import javax.xml.namespace.QName;

import org.eclipse.cosmos.me.sdd.schema.CapacityConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConditionalPropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConsumptionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.PropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.VersionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public interface IResourceHandler {
	static final String QNAME = "qname"; // service property name
	
	Object getPropertyValue(SDDContext ctxt, ResourceType rsrc, QName qname);
	Object getVersionValue(SDDContext ctxt, ResourceType rsrc);
	boolean evaluate(SDDContext ctxt, ResourceType rsrc, CapacityConstraintType constraint);
	boolean evaluate(SDDContext ctxt, ResourceType rsrc, ConsumptionConstraintType constraint);
	boolean evaluate(SDDContext ctxt, ResourceType rsrc, PropertyConstraintType constraint);
	boolean evaluate(SDDContext ctxt, ResourceType rsrc, ConditionalPropertyConstraintType constraint);
	boolean evaluate(SDDContext ctxt, ResourceType rsrc, VersionConstraintType constraint);
}
