/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.o10r.impl;

import org.eclipse.cosmos.me.sdd.cr.ResourceHandler;
import org.eclipse.cosmos.me.sdd.o10r.Orchestrator;
import org.eclipse.cosmos.me.sdd.op.OperationHandler;
import org.eclipse.cosmos.me.sdd.schema.AdditionalContentType;
import org.eclipse.cosmos.me.sdd.schema.ArtifactType;
import org.eclipse.cosmos.me.sdd.schema.DeploymentDescriptorType;
import org.eclipse.cosmos.me.sdd.schema.InstallableUnitType;
import org.eclipse.cosmos.me.sdd.schema.InstallationArtifactsType;
import org.eclipse.cosmos.me.sdd.schema.OperationType;
import org.eclipse.cosmos.me.sdd.schema.PackageDescriptorType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;
import org.eclipse.cosmos.me.sdd.schema.marshal.Marshaller;

public class OrchestratorImpl implements Orchestrator {
	private Marshaller marshaller;
	private OperationHandler ophandler;
	private ResourceHandler rsrcHandler;
	
	public void setMarshaller(Marshaller marshaller) {
		this.marshaller = marshaller;
	}
	
	public void unsetMarshaller(Marshaller marshaller) {
		this.marshaller = null;
	}
	
	public void setOperationHandlerByType(OperationHandler ophandler) {
		this.ophandler = ophandler;
	}
	
	public void unsetOperationHandlerByType(OperationHandler ophandler) {
		this.ophandler = null;
	}
	
	public void setResourceHandler(ResourceHandler rsrcHandler) {
		this.rsrcHandler = rsrcHandler;
	}
	
	public void unsetResourceHandler(ResourceHandler rsrcHandler) {
		this.rsrcHandler = null;
	}
	
	public void deploy(String packageUri, String operation) {
		OperationType op = OperationType.fromValue(operation);
		switch (op) {
		case INSTALL:
		case UNINSTALL:
			installableUnit(packageUri, op);
			break;
		default:
			break;
		}
	}

	private void installableUnit(String packageUri, OperationType op) {
		SDDContext ctxt = new SddContextImpl(marshaller, packageUri);
		PackageDescriptorType pd = ctxt.getPackageDescriptor();
		if (pd != null) {
			DeploymentDescriptorType dd = ctxt.getDeploymentDescriptor();
			if (dd != null) {
				new VariableResolver(ctxt, rsrcHandler).installableUnitResolver();
				
				RequirementsResolver reqResolver = new RequirementsResolver(ctxt, rsrcHandler);
				if (reqResolver.installableUnitResolver()) {
					InstallableUnitType unit = dd.getInstallableUnit();
					if (unit != null) {
						if (unit.getArtifacts() != null) {
							InstallationArtifactsType artifacts = unit.getArtifacts();
							switch (op) {
							case INSTALL:
								if (artifacts.getInstallArtifact() != null) {
									ArtifactType artifact = artifacts.getInstallArtifact();
									ophandler.invokeAction(ctxt, artifact, op);
									for (AdditionalContentType c : artifact.getAdditionalContent()) {
										ophandler.invokeAction(ctxt, artifact, c, op);
									}
								}
								break;
							case UNINSTALL:
								if (artifacts.getUninstallArtifact() != null) {
									ophandler.invokeAction(ctxt, artifacts.getUninstallArtifact(), op);
								}
								break;
							}
						}
					}
				} else {
					System.out.println("Requirements are not met...");
				}
			}
		}
	}
}
