/*******************************************************************************
 * Copyright (c) 2009 SAS Institute, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute - initial API and implementation
 *     CA, Inc - Bug 268158
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.o10r.impl;

import java.util.List;

import org.eclipse.cosmos.me.sdd.cr.ResolverByQname;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

/**
 * Class that knows how to walk the topology root.
 * 
 * @author jehamm
 *
 */
public class TopologyWalker {
	SDDContext _ctxt;
	InstallableUnitWalker _installableUnitWalker;
	
	/**
	 * Constructor.
	 * @param deploymentType
	 */
	public TopologyWalker(SDDContext ctxt, ResolverByQname resolver)
	{
		_ctxt = ctxt;
		// Construct a walker for running down the installable unit types.
		_installableUnitWalker = new InstallableUnitWalker(_ctxt, resolver);
	}

	/**
	 * Work our way down the hierarchy that is defined in the topology.
	 */
	public void walk() {
		// Get the list of resources from the top level topology.
		List<ResourceType> resources = _ctxt.getDeploymentDescriptor().getTopology().getResource();
		// Iterate over the list of resources.
		for (ResourceType topologyResource : resources) {
			// walk the resource through the InstallableUnit walker.
			walkResource(topologyResource);
		}
	}
	
	/**
	 * Internal walker that knows how to walk the hierarchy of resources. It is called again and
	 * again as it walks the tree of resources.
	 * 
	 * @param resource
	 */
	private void walkResource(ResourceType resource) {
		// Should we create a resolution object here or just pass the ResourceType?
		
		// This will iterate over the entire InstallableUnit. -- each time -- good or bad???
		_installableUnitWalker.walk(resource);
		
		for (ResourceType hostedResource : resource.getHostedResource()) {
			walkResource(hostedResource);	
		}
	}
}
