/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.PropertiesContainer");
dojo.require("dijit.layout.ContentPane");
dojo.require("dijit.TitlePane");
dojo.require("dojox.grid.Grid");
dojo.require("dojox.grid._data.model");


dojo.declare(
	// class
	"org.eclipse.cosmos.provisional.dr.ps.components.widget.SimplePropertiesTable",
	// superclass	
	[dojox.Grid],
	
	// member variables/functions
	{
		widgetClass:'cosmos:SimplePropertiesTable',
		create: function(params, srcNodeRef) {
			//need to delay creation 
			var queryHandler = null;
			var initParam = null;
			//lets check if the contextMap has any query handlers
			if (((typeof(params.contextMap)) != 'undefined') && (params.contextMap != null)){
				initParam = params.dataMap[params.contextMap.nodeClass];
				if ((initParam) && ((typeof(initParam['queryHandler']))!='undefined')){
			    	queryHandler = params.UIContext.createObject(initParam['queryHandler']);					
				}
				else{			
					//classes can contain multiple tags
					var nodeClasses = params.contextMap.nodeClass.split(" ");
					//check the first tag since this is the tag that will contain where the data came from
						initParam = params.dataMap[nodeClasses[0]];
						dojo.mixin(params, initParam);
						if ((initParam) && ((typeof(initParam['queryHandler']))!='undefined')){
					    	queryHandler = params.UIContext.createObject(initParam['queryHandler']);					
						}
				}
				//if the contextMap has a store use that... should try to add query object to get it from the store
				if (typeof(params.contextMap.store) != 'undefined'){
					this.model=new dojox.grid.data.Table(null, params.contextMap.store);														
					return org.eclipse.cosmos.provisional.dr.ps.components.widget.SimplePropertiesTable.superclass.create.apply(this, arguments);
				}
			}
			if (queryHandler == null){
				if (params.initQueryHandler != null)
					queryHandler=new org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery({queryHandler: params.initQueryHandler});
			}

			if (queryHandler != null){
				var self = this;
				var funcArgs = arguments;
				//maybe tagged context data contains configuration options for this widget
				if (initParam != null)
					dojo.mixin(funcArgs[0], initParam);
				params.UIContext.submitQuery({queryObject:queryHandler, item:params.contextMap,
											onItem: function(data){
														self.model=new dojox.grid.data.Table(null, data);														
														org.eclipse.cosmos.provisional.dr.ps.components.widget.SimplePropertiesTable.superclass.create.apply(self, funcArgs);
				  									}
										  }); 
				
			}
		}
		
	}
);