/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.PSVIProvider;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationConstants;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationMessage;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.SMLIFIdentity;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.databuilders.IDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.reference.URIReference;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataBuilder<T>
extends DefaultHandler
implements IDataBuilder<T> {
    private Map<String, Object> init;
    private Locator locator;
    private String targetNamespace;
    private String defaultNamespace;
    private Map<String, String> prefixMap;
    private boolean validity;
    private IValidationMessage errorMessage;
    private String filePath;
    private int supportedEvents;
    private IValidationOutput<?, ?> messageOutputter;
    private PSVIProvider psvi;
    private int baseLineNumber;
    private String[] aliases;
    private boolean smlElement;
    private boolean smlifElement;
    private boolean modelBaseURICanBeCalculated;
    private boolean modelBaseURIHasBeenCalculated;
    private Stack<URI> baseURIInfoset = new Stack();

    public AbstractDataBuilder() {
        this.setStructureValidity(true);
        this.targetNamespace = "";
        this.prefixMap = new Hashtable<String, String>();
    }

    @Override
    public void reset() {
        this.baseURIInfoset.clear();
    }

    @Override
    public void initialize(Map<String, Object> init) {
        this.init = init;
        this.psvi = (PSVIProvider)init.get("psvi.instance");
        this.messageOutputter = (IValidationOutput)init.get("validation.output");
        Object tmp = init.get("base.line.number");
        this.baseLineNumber = tmp == null ? 0 : (Integer)tmp;
        tmp = init.get("document.aliases");
        this.aliases = tmp == null ? new String[]{} : (String[])tmp;
        this.baseURIInfoset.push((URI)init.get("document.baseURI"));
        this.modelBaseURICanBeCalculated = false;
        this.modelBaseURIHasBeenCalculated = false;
    }

    @Override
    public void endDefinitions() {
    }

    @Override
    public void endInstances() {
    }

    @Override
    public void startDefinitions() {
    }

    @Override
    public void startInstances() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.smlifElement = "http://www.w3.org/2008/09/sml-if".equals(uri);
        this.smlElement = "http://www.w3.org/2008/09/sml".equals(uri);
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "schema".equals(localName)) {
            this.targetNamespace = attributes.getValue("targetNamespace");
            int i = 0;
            int attributeCount = attributes.getLength();
            while (i < attributeCount) {
                String[] attributeName = SMLValidatorUtil.tokenizeName(attributes.getQName(i));
                if ("xmlns".equals(attributeName[0])) {
                    this.prefixMap.put(attributeName[1], attributes.getValue(i));
                } else if ("xmlns".equals(attributeName[1])) {
                    this.defaultNamespace = attributes.getValue(i);
                }
                ++i;
            }
        }
        if (this.modelBaseURICanBeCalculated && !this.modelBaseURIHasBeenCalculated) {
            String baseURI;
            SMLIFIdentity identity;
            this.modelBaseURIHasBeenCalculated = true;
            if (!this.baseURIInfoset.empty() && this.baseURIInfoset.peek() == null && (identity = (SMLIFIdentity)SMLValidatorUtil.retrieveDataStructure(0, "org.eclipse.cosmos.rm.validation.IdentityDataBuilder")) != null && (baseURI = identity.getBaseURI()) != null) {
                int lineNum = this.getLocator() == null ? -1 : this.getLocator().getLineNumber();
                IValidationOutput<?, ?> logger = this.getMessageOutputter();
                URI candidateModelBaseURI = URIReference.validModelBaseURIAsURI(baseURI, null, logger, lineNum);
                if (candidateModelBaseURI != null) {
                    this.baseURIInfoset.pop();
                    this.baseURIInfoset.push(candidateModelBaseURI);
                }
            }
        }
        String xmlBaseAttrValue = attributes.getValue("xml:base");
        URI xmlBaseURI = null;
        if (xmlBaseAttrValue == null) {
            xmlBaseURI = this.baseURIInfoset.empty() ? null : this.baseURIInfoset.peek();
        } else {
            xmlBaseURI = this.validateBaseURIADB(xmlBaseAttrValue);
            if (!this.baseURIInfoset.empty() && this.baseURIInfoset.peek() != null) {
                xmlBaseURI = this.baseURIInfoset.peek().resolve(xmlBaseURI);
            }
        }
        this.baseURIInfoset.push(xmlBaseURI);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "schema".equals(localName)) {
            this.targetNamespace = "";
            this.prefixMap.clear();
        }
        this.baseURIInfoset.pop();
        if ("http://www.w3.org/2008/09/sml-if".equals(uri) && "identity".equals(localName)) {
            this.modelBaseURICanBeCalculated = true;
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public boolean isStructureValid() {
        return this.validity;
    }

    @Override
    public void setStructureValidity(boolean validity) {
        this.validity = validity;
    }

    @Override
    public IValidationMessage getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void setErrorMessage(IValidationMessage error) {
        this.errorMessage = error;
    }

    protected void appendToErrorMessage(String error) {
        String errMsg = this.errorMessage.getAttribute("attribute.message", null);
        if (errMsg == null) {
            errMsg = "";
        }
        if (errMsg.length() > 0) {
            errMsg = String.valueOf(errMsg) + IValidationConstants.LINE_SEPARATOR;
        }
        errMsg = String.valueOf(errMsg) + error;
    }

    public Map<String, String> getPrefixMap() {
        return this.prefixMap;
    }

    public void setPrefixMap(Map<String, String> prefix) {
        this.prefixMap = prefix;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    @Override
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void comment(char[] cs, int i, int j) {
    }

    protected void addEvent(int event) {
        this.addEvents(new int[]{event});
    }

    protected void addEvents(int[] events) {
        int i = 0;
        while (i < events.length) {
            this.supportedEvents |= 1 << events[i];
            ++i;
        }
    }

    @Override
    public int getSupportedEvents() {
        return this.supportedEvents;
    }

    @Override
    public IValidationOutput<?, ?> getMessageOutputter() {
        return this.messageOutputter;
    }

    @Override
    public void setMessageOutputter(IValidationOutput<?, ?> messageOutputter) {
        this.messageOutputter = messageOutputter;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public Map<String, Object> getInit() {
        return this.init;
    }

    public PSVIProvider getPsvi() {
        return this.psvi;
    }

    public void setPsvi(PSVIProvider psvi) {
        this.psvi = psvi;
    }

    public int getBaseLineNumber() {
        return this.baseLineNumber;
    }

    public void setBaseLineNumber(int baseLineNumber) {
        this.baseLineNumber = baseLineNumber;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public AnnotationResult retrieveElementAnnotation(String uri, String localName) {
        ElementPSVI elementPSVI = this.getPsvi().getElementPSVI();
        XSElementDeclaration elementDeclaration = elementPSVI == null ? null : elementPSVI.getElementDeclaration();
        return SMLValidatorUtil.retrieveAnnotation(elementDeclaration, uri, localName);
    }

    public boolean isSMLElement() {
        return this.smlElement;
    }

    public boolean isSMLIFElement() {
        return this.smlifElement;
    }

    public int getContextLineNumber() {
        return this.getBaseLineNumber() + this.getLocator().getLineNumber() - 1;
    }

    @Override
    public URI getCurrentBaseURI() {
        return this.baseURIInfoset.isEmpty() ? null : this.baseURIInfoset.peek();
    }

    private URI validateBaseURIADB(String URIAsString) {
        int lineNum = this.getLocator() == null ? -1 : this.getLocator().getLineNumber();
        IValidationOutput<?, ?> logger = this.getMessageOutputter();
        URI candidateModelBaseURI = URIReference.validModelBaseURIAsURI(URIAsString, null, logger, lineNum);
        return candidateModelBaseURI;
    }

    public static class AnnotationResult {
        private List<Node> nodes = new ArrayList<Node>();
        private XSTypeDefinition type;

        public Node[] getNodes() {
            return this.nodes.toArray(new Node[this.nodes.size()]);
        }

        public void addNode(Node node) {
            this.nodes.add(node);
        }

        public XSTypeDefinition getType() {
            return this.type;
        }

        public void setType(XSTypeDefinition type) {
            this.type = type;
        }
    }
}

