/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementLocation;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementModel;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMStructure {
    private Map<String, Node> documents = new HashMap<String, Node>();
    private Map<Node, String[]> aliasesByDocumentNode = new HashMap<Node, String[]>();
    private List<Node> orphanedDocuments = new ArrayList<Node>();
    private Map<Node, ElementLocation> lineNumberMap = new HashMap<Node, ElementLocation>();

    public Node get(String alias) {
        return this.documents.get(alias);
    }

    public String[] getAliases(Node document) {
        return this.aliasesByDocumentNode.get(document);
    }

    public ElementLocation getLocation(Node node) {
        return this.lineNumberMap.get(node);
    }

    public List<Node> getOrphanedDocuments() {
        return this.orphanedDocuments;
    }

    public Map<String, Node> getDocuments() {
        return this.documents;
    }

    public void add(Node documentNode, String[] aliases) {
        if (aliases == null || aliases.length <= 0) {
            this.orphanedDocuments.add(documentNode);
            return;
        }
        int i = 0;
        while (i < aliases.length) {
            this.documents.put(aliases[i], documentNode);
            ++i;
        }
        this.aliasesByDocumentNode.put(documentNode.getOwnerDocument(), aliases);
    }

    public void add(Node documentNode, ElementModel location) {
        this.add(documentNode, location.getAliases());
        this.lineNumberMap.put(documentNode, location);
    }

    public Node getOrphan(int index) {
        return index >= 0 && index < this.orphanedDocuments.size() ? this.orphanedDocuments.get(index) : null;
    }

    public int getOrphan(Node document) {
        int index = -1;
        int i = 0;
        while (i < this.orphanedDocuments.size()) {
            if (this.orphanedDocuments.get(i) == document) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public int size() {
        return this.documents.size() + this.orphanedDocuments.size();
    }
}

