/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.reference;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import org.eclipse.cosmos.rm.internal.validation.artifacts.DOMStructure;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.SMLIFIdentity;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.reference.IReferenceExpression;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIReference
implements IReferenceExpression {
    private static final char[] RESERVED_CHARACTERS = new char[]{'$', '&', '+', ',', '/', ':', ';', '=', '?', '@', '-', '_', '.', '!', '*', '(', ')', '#', '[', ']', '%', '\'', '\\'};
    private URI base;
    private URI baseURIValue;
    private Node context;
    private URI reference;
    private String documentReference;
    private boolean transformed;
    private DOMStructure domStructure;

    public URIReference(Node context, String reference) throws URISyntaxException {
        this(context, reference, null);
    }

    public URIReference(Node context, String reference, URI baseURIValue) throws URISyntaxException {
        if (reference == null) {
            throw new URISyntaxException("", SMLValidationMessages.errorReferenceNullURI);
        }
        this.context = context;
        reference = this.trim(reference);
        reference = this.encodeCharacters(reference);
        this.reference = new URI(reference);
        this.verifyImplementationSupportsURI(this.reference);
        this.baseURIValue = baseURIValue;
        this.verifyImplementationSupportsURI(this.baseURIValue);
    }

    private void verifyImplementationSupportsURI(URI verifyURI) throws URISyntaxException {
        if (verifyURI != null && verifyURI.isOpaque()) {
            throw new URISyntaxException("", SMLValidationMessages.errorReferenceOpaqueURI);
        }
    }

    private String encodeCharacters(String uri) {
        if (uri == null) {
            return null;
        }
        char[] uriChars = uri.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < uriChars.length) {
            if (Character.isLetterOrDigit(uriChars[i]) || this.isCharacterReserved(uriChars[i])) {
                buffer.append(uriChars[i]);
            } else {
                buffer.append("%");
                buffer.append(this.convertToHex(uriChars[i] / 16));
                buffer.append(this.convertToHex(uriChars[i] % 16));
            }
            ++i;
        }
        return buffer.toString();
    }

    private char convertToHex(int dec) {
        return dec >= 0 && dec <= 9 ? String.valueOf(dec).toCharArray()[0] : (dec <= 15 ? (char)(65 + (dec - 10)) : (char)dec);
    }

    private int convertToDecimal(char ch) {
        return Character.isDigit(ch) ? Integer.parseInt(String.valueOf(ch)) : (ch >= 'A' && ch <= 'F' ? 10 + (ch - 65) : -1);
    }

    private String decodeCharacters(String uri) {
        int precentInx;
        if (uri == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int cursorInx = 0;
        int uriPartLength = uri.length();
        while (uriPartLength > cursorInx && (precentInx = uri.indexOf(37, cursorInx)) >= 0) {
            buffer.append(uri.substring(cursorInx, precentInx));
            if (uriPartLength > precentInx + 2) {
                char firstDigit = uri.charAt(precentInx + 1);
                char secondDigit = uri.charAt(precentInx + 2);
                int firstDecimalDigit = this.convertToDecimal(firstDigit);
                int secondDecimalDigit = this.convertToDecimal(secondDigit);
                if (firstDecimalDigit >= 0 && secondDecimalDigit >= 0) {
                    buffer.append((char)(firstDecimalDigit * 16 + secondDecimalDigit));
                } else {
                    buffer.append(37 + firstDigit + secondDigit);
                }
            }
            cursorInx = precentInx + 3;
        }
        if (uriPartLength > cursorInx) {
            buffer.append(uri.substring(cursorInx));
        }
        return buffer.toString();
    }

    private boolean isCharacterReserved(char c) {
        int i = 0;
        while (i < RESERVED_CHARACTERS.length) {
            if (c == RESERVED_CHARACTERS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String trim(String str) {
        str = str.trim();
        str = str.replaceAll("\\n", "");
        str = str.replaceAll("\\r", "");
        return str;
    }

    @Override
    public String getDocumentReference() throws URISyntaxException {
        if (this.documentReference == null) {
            int fragmentInx;
            String referenceStr = null;
            try {
                referenceStr = URLDecoder.decode(this.reference.toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new URISyntaxException(this.reference.toString(), e.getMessage());
            }
            int n = fragmentInx = referenceStr == null ? -1 : referenceStr.indexOf(35);
            if (fragmentInx >= 0) {
                referenceStr = referenceStr.substring(0, fragmentInx).trim();
            }
            this.documentReference = referenceStr;
            if (!this.isDocumentEmbedded(referenceStr) && !this.isTransformed()) {
                this.documentReference = null;
                this.transform();
                return this.getDocumentReference();
            }
        }
        return this.decodeCharacters(this.documentReference);
    }

    public String getFragment() throws URISyntaxException {
        this.getDocumentReference();
        return this.reference == null ? null : this.decodeCharacters(this.reference.getFragment());
    }

    private boolean isDocumentEmbedded(String document) {
        if (this.domStructure == null) {
            this.domStructure = (DOMStructure)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.DocumentDOMBuilder");
        }
        return this.domStructure != null && this.domStructure.get(document) != null;
    }

    @Override
    public boolean isTransformed() {
        return this.transformed;
    }

    public String baseURIReadyToTransform() {
        return this.baseURIReadyToTransform(false);
    }

    private String baseURIReadyToTransform(Boolean updateBaseURI) {
        String message = null;
        if (!this.reference.isAbsolute() && !this.isFragmentOnly()) {
            if (this.baseURIValue == null) {
                message = SMLValidationMessages.errorMissingBaseURI;
            } else if (this.baseURIValue.isAbsolute()) {
                if (updateBaseURI.booleanValue()) {
                    this.base = this.baseURIValue;
                }
            } else {
                message = NLS.bind((String)SMLValidationMessages.errorRelativeBaseURI, (Object)this.baseURIValue.toString());
            }
        }
        SMLIFIdentity identity = (SMLIFIdentity)SMLValidatorUtil.retrieveDataStructure(0, "org.eclipse.cosmos.rm.validation.IdentityDataBuilder");
        if (message != null && identity != null && identity.getTestUtilityRunning()) {
            String artificial = SMLValidationMessages.artificialIdentity;
            String baseURI = identity.getBaseURI();
            if (baseURI == null) {
                message = String.valueOf(artificial) + " " + SMLValidationMessages.errorBadBaseURI;
            } else {
                try {
                    URI tryBase = new URI(baseURI);
                    if (!tryBase.isAbsolute()) {
                        message = NLS.bind((String)SMLValidationMessages.errorBadValue, (Object[])new String[]{SMLValidationMessages.modelBaseURI, baseURI});
                        message = String.valueOf(artificial) + " " + message + SMLValidationMessages.errorAbsoluteURIRequired;
                    } else {
                        message = null;
                        if (updateBaseURI.booleanValue()) {
                            this.base = tryBase;
                        }
                    }
                }
                catch (URISyntaxException e) {
                    message = e.getMessage();
                }
            }
        }
        return message;
    }

    @Override
    public void transform() throws URISyntaxException {
        String query;
        String path;
        String authority;
        String scheme;
        this.transformed = true;
        if (this.reference.isAbsolute() || this.isFragmentOnly()) {
            return;
        }
        String message = this.baseURIReadyToTransform(true);
        if (message != null) {
            throw new URISyntaxException("", message);
        }
        if (this.defined(this.reference.getScheme())) {
            scheme = this.reference.getScheme();
            authority = this.reference.getAuthority();
            path = this.reference.getPath();
            query = this.reference.getQuery();
        } else {
            if (this.defined(this.reference.getAuthority())) {
                authority = this.reference.getAuthority();
                path = this.reference.getPath();
                query = this.reference.getQuery();
            } else {
                if (this.defined(this.reference.getPath())) {
                    path = this.reference.getPath().startsWith("/") ? this.removeDotSegments(this.reference.getPath()) : this.removeDotSegments(this.mergePath(this.base, this.reference));
                    query = this.reference.getQuery();
                } else {
                    path = this.base.getPath();
                    query = this.defined(this.reference.getQuery()) ? this.reference.getQuery() : this.base.getQuery();
                }
                authority = this.base.getAuthority();
            }
            scheme = this.base.getScheme();
        }
        String fragment = this.reference.getFragment();
        this.reference = new URI(this.decodeCharacters(scheme), this.decodeCharacters(authority), this.decodeCharacters(path), this.decodeCharacters(query), this.decodeCharacters(fragment));
    }

    private boolean isFragmentOnly() {
        return this.isNull(this.reference.getAuthority()) && this.isNull(this.reference.getHost()) && this.isNull(this.reference.getPath()) && this.isNull(this.reference.getQuery()) && !this.isNull(this.reference.getFragment());
    }

    private boolean isNull(String str) {
        return str == null || str.length() <= 0;
    }

    private String mergePath(URI base, URI relative) {
        int rightMostSlash;
        if (this.defined(base.getAuthority()) && !this.defined(base.getPath())) {
            return "/" + relative.getPath();
        }
        String basePath = base.getPath();
        basePath = !this.defined(basePath) ? "" : ((rightMostSlash = basePath.lastIndexOf("/")) >= 0 ? basePath.substring(0, rightMostSlash + 1) : "");
        return String.valueOf(basePath) + relative.getPath();
    }

    private String removeDotSegments(String input) {
        String output = "";
        while (input.length() > 0) {
            int length;
            String matchedPrefix = this.findMatch(input, new String[]{"../", "./"}, new String[0]);
            if (matchedPrefix != null) {
                length = matchedPrefix.length();
                input = input.length() > length ? input.substring(length) : "";
                continue;
            }
            matchedPrefix = this.findMatch(input, new String[]{"/./"}, new String[]{"/."});
            if (matchedPrefix != null) {
                length = matchedPrefix.length();
                input = input.length() > length ? input.substring(length) : "";
                input = "/" + input;
                continue;
            }
            matchedPrefix = this.findMatch(input, new String[]{"/../"}, new String[]{"/.."});
            if (matchedPrefix != null) {
                length = matchedPrefix.length();
                input = input.length() > length ? input.substring(length) : "";
                input = "/" + input;
                int inx = output.lastIndexOf("/");
                output = inx > 0 ? output.substring(0, inx) : "";
                continue;
            }
            matchedPrefix = this.findMatch(input, new String[0], new String[]{".", ".."});
            if (matchedPrefix != null) {
                input = "";
                continue;
            }
            int inx = input.indexOf("/");
            if (inx == 0) {
                output = String.valueOf(output) + "/";
                input = input.substring(1);
                inx = input.indexOf("/");
            }
            if (inx > 0) {
                output = String.valueOf(output) + input.substring(0, inx);
                input = input.substring(inx);
                continue;
            }
            output = String.valueOf(output) + input;
            input = "";
        }
        return output;
    }

    private String findMatch(String input, String[] prefix, String[] equalityCheck) {
        int i = 0;
        while (i < prefix.length) {
            if (input.startsWith(prefix[i])) {
                return prefix[i];
            }
            ++i;
        }
        i = 0;
        while (i < equalityCheck.length) {
            if (input.equals(equalityCheck[i])) {
                return equalityCheck[i];
            }
            ++i;
        }
        return null;
    }

    private boolean defined(String field) {
        return field != null && field.length() > 0;
    }

    public Node retrieveDocumentDOM() throws URISyntaxException {
        Node documentNode;
        String document = this.getDocumentReference();
        if (document.length() <= 0) {
            return this.context;
        }
        String scheme = this.reference.getScheme();
        Node node = documentNode = document == null ? null : this.domStructure.get(document);
        if (scheme == null || documentNode != null) {
            return documentNode;
        }
        try {
            return SMLValidatorUtil.retrieveRemoteDocument(this.reference.toString());
        }
        catch (SMLValidatorUtil.RemoteRetrievalException remoteRetrievalException) {
            return null;
        }
    }

    protected URI getReference() {
        return this.reference;
    }

    protected void setReference(URI reference) {
        this.reference = reference;
    }

    protected URI getBase() {
        return this.base;
    }

    public void setBase(URI base) throws URISyntaxException {
        this.base = base;
        this.verifyImplementationSupportsURI(this.base);
    }

    public static String validURIReference(String candidateRef, URI baseURI, IValidationOutput<?, ?> logger, int lineNumber, String diagnosticRefName) {
        URIReference candidateRefURI = URIReference.validReference(candidateRef, baseURI, logger, lineNumber, diagnosticRefName);
        if (candidateRefURI == null) {
            return null;
        }
        String returnValue = null;
        try {
            String fragment = candidateRefURI.getFragment();
            returnValue = fragment == null ? candidateRefURI.getDocumentReference() : String.valueOf(candidateRefURI.getDocumentReference()) + "#" + fragment;
        }
        catch (URISyntaxException e) {
            if (logger != null) {
                String message = String.valueOf(NLS.bind((String)SMLValidationMessages.errorBadGetDocRefValue, (Object[])new String[]{diagnosticRefName, candidateRef})) + " " + e.getMessage();
                logger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNumber, message));
            }
            return null;
        }
        return returnValue;
    }

    public static String validAliasOrAliasPrefix(String candidateAlias, URI baseURI, IValidationOutput<?, ?> logger, int lineNumber, String diagnosticAliasName) {
        URIReference candidateAliasURI = URIReference.validAliasOrAliasPrefixAsURIRef(candidateAlias, baseURI, logger, lineNumber, diagnosticAliasName);
        if (candidateAliasURI == null) {
            return null;
        }
        String returnValue = null;
        try {
            returnValue = candidateAliasURI.getDocumentReference();
        }
        catch (URISyntaxException e) {
            if (logger != null) {
                String message = String.valueOf(NLS.bind((String)SMLValidationMessages.errorBadGetDocRefValue, (Object[])new String[]{diagnosticAliasName, candidateAlias})) + " " + e.getMessage();
                logger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNumber, message));
            }
            return null;
        }
        return returnValue;
    }

    public static URI validAliasOrAliasPrefixAsURI(String candidateAlias, URI baseURI, IValidationOutput<?, ?> logger, int lineNumber, String diagnosticAliasName) {
        URIReference candidateAliasURI = URIReference.validAliasOrAliasPrefixAsURIRef(candidateAlias, baseURI, logger, lineNumber, diagnosticAliasName);
        if (candidateAliasURI == null) {
            return null;
        }
        return candidateAliasURI.reference;
    }

    public static URIReference validAliasOrAliasPrefixAsURIRef(String candidateAlias, URI baseURI, IValidationOutput<?, ?> logger, int lineNumber, String diagnosticAliasName) {
        URIReference candidateAliasURI = URIReference.validAbsoluteURI(candidateAlias, baseURI, logger, lineNumber, diagnosticAliasName);
        if (candidateAliasURI == null) {
            return null;
        }
        if (candidateAliasURI.reference.getFragment() != null) {
            if (logger != null) {
                String message = NLS.bind((String)SMLValidationMessages.errorAliasHasFragment, (Object[])new String[]{diagnosticAliasName, candidateAlias});
                logger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNumber, message));
            }
            return null;
        }
        try {
            candidateAliasURI.getDocumentReference();
        }
        catch (URISyntaxException e) {
            if (logger != null) {
                String message = String.valueOf(NLS.bind((String)SMLValidationMessages.errorBadGetDocRefValue, (Object[])new String[]{diagnosticAliasName, candidateAlias})) + " " + e.getMessage();
                logger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNumber, message));
            }
            return null;
        }
        return candidateAliasURI;
    }

    public static boolean validModelBaseURI(String candidateModelBaseURI, URI baseURI, IValidationOutput<?, ?> logger, int lineNumber) {
        return URIReference.validAliasOrAliasPrefix(candidateModelBaseURI, baseURI, logger, lineNumber, SMLValidationMessages.modelBaseURI) != null;
    }

    public static URI validModelBaseURIAsURI(String candidateModelBaseURIString, URI baseURI, IValidationOutput<?, ?> logger, int lineNumber) {
        String modelBaseURIString = URIReference.validAliasOrAliasPrefix(candidateModelBaseURIString, baseURI, logger, lineNumber, SMLValidationMessages.modelBaseURI);
        if (modelBaseURIString == null) {
            return null;
        }
        URIReference modelBaseURIReference = URIReference.validReference(modelBaseURIString, null, logger, lineNumber, SMLValidationMessages.modelBaseURI);
        if (modelBaseURIReference == null) {
            return null;
        }
        return modelBaseURIReference.reference;
    }

    private static URIReference validAbsoluteURI(String candidateAbsoluteURI, URI baseURI, IValidationOutput<?, ?> logger, int lineNumber, String diagnosticAbsoluteURIName) {
        String message = null;
        URIReference candidateAbsoluteURIReference = URIReference.validReference(candidateAbsoluteURI, baseURI, logger, lineNumber, diagnosticAbsoluteURIName);
        if (candidateAbsoluteURIReference == null) {
            return null;
        }
        if (!candidateAbsoluteURIReference.reference.isAbsolute()) {
            if (logger != null) {
                message = String.valueOf(NLS.bind((String)SMLValidationMessages.errorBadValue, (Object[])new String[]{diagnosticAbsoluteURIName, candidateAbsoluteURI})) + SMLValidationMessages.errorAbsoluteURIRequired;
                logger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNumber, message));
            }
            return null;
        }
        return candidateAbsoluteURIReference;
    }

    private static URIReference validReference(String candidateRef, URI baseURI, IValidationOutput<?, ?> logger, int lineNumber, String diagnosticRefName) {
        String message = null;
        URIReference candidateReference = null;
        try {
            candidateReference = new URIReference(null, candidateRef, baseURI);
        }
        catch (URISyntaxException e) {
            if (logger != null) {
                message = e.getMessage().trim();
                if (message.endsWith(":")) {
                    message = message.substring(0, message.length() - 1);
                }
                message = String.valueOf(NLS.bind((String)SMLValidationMessages.errorBadValue, (Object[])new String[]{diagnosticRefName, candidateRef})) + message;
                logger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNumber, message));
            }
            return null;
        }
        message = candidateReference.baseURIReadyToTransform(true);
        if (message != null) {
            if (logger != null) {
                message = String.valueOf(NLS.bind((String)SMLValidationMessages.errorBadBaseURIValue, (Object[])new String[]{diagnosticRefName, candidateRef})) + message;
                logger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNumber, message));
            }
            return null;
        }
        if (!candidateReference.isFragmentOnly()) {
            try {
                candidateReference.getDocumentReference();
            }
            catch (URISyntaxException e) {
                if (logger != null) {
                    message = String.valueOf(NLS.bind((String)SMLValidationMessages.errorBadGetDocRefValue, (Object[])new String[]{diagnosticRefName, candidateRef})) + " " + e.getMessage();
                    logger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNumber, message));
                }
                return null;
            }
        }
        return candidateReference;
    }
}

