/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.text.MessageFormat;
import java.util.Iterator;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.eclipse.cosmos.common.provisional.exceptions.CosmosException;
import org.eclipse.cosmos.dc.broker.provisional.client.BrokerClient;
import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.test.CommandEntry;
import org.eclipse.cosmos.dc.test.CosmosCLI;
import org.eclipse.cosmos.dc.test.Messages;
import org.eclipse.cosmos.dc.test.Tokenizer;

class CmdGetSoapVersion
extends CommandEntry {
    private static final String DM_NAMESPACE = "http://datamanager.provisional.dc.cosmos.eclipse.org";
    private String _id = null;
    private String eprstr = null;

    public CmdGetSoapVersion(CosmosCLI cli) {
        this._cli = cli;
        this._command = new String("GetSoapVersion");
        this._usage_entry = new String("USAGE_SOAPVERSION_INFO");
    }

    public void performAction() throws Exception {
        if (!this.getEPR()) {
            return;
        }
        EndpointReference epr = new EndpointReference(this.eprstr);
        ServiceClient sender = null;
        Options options = new Options();
        options.setTo(epr);
        options.setTransportInProtocol("http");
        try {
            sender = new ServiceClient();
        }
        catch (AxisFault a) {
            throw new CosmosException("AxisFault");
        }
        sender.setOptions(options);
        Object ret = null;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(DM_NAMESPACE, "tns");
        OMElement tsRequest = fac.createOMElement("getSoapVersion", omNs);
        OMElement result = null;
        try {
            result = sender.sendReceive(tsRequest);
        }
        catch (AxisFault a) {
            throw new CosmosException(a.getMessage());
        }
        String sv = this.ParseResponse(result);
        this._cli.logMessage(sv);
    }

    public boolean validateArguments(Tokenizer st, String line) {
        if (!st.hasMoreTokens()) {
            this._cli.logMessage(Messages.getString("MISSING_DM_ID_ERR"));
            return false;
        }
        this._id = st.nextToken();
        return true;
    }

    private String ParseResponse(OMElement result) {
        Iterator groupIter = result.getChildElements();
        if (!groupIter.hasNext()) {
            return Messages.getString("UNEXPECTED_RESPONSE");
        }
        OMElement elem = (OMElement)groupIter.next();
        if (elem.getLocalName().equals("version")) {
            return new String(MessageFormat.format(Messages.getString("SOAP_VERSION_INFO"), elem.getText()));
        }
        return Messages.getString("UNEXPECTED_RESPONSE");
    }

    private boolean getEPR() throws Exception {
        BrokerClient brokerclient = new BrokerClient(this._cli.getBrokerEPR());
        DataManager dm = null;
        try {
            dm = brokerclient.getDataManagerById(this._id);
        }
        catch (Exception e) {
            if (e.getMessage().equals("unknown")) {
                this._cli.logMessage(MessageFormat.format(Messages.getString("DMID_NOT_FOUND_ERR"), this._id));
                return false;
            }
            throw e;
        }
        this.eprstr = dm.getServiceEPR("http://www.eclipse.org/cosmos/datamanager");
        return true;
    }
}

