/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.cosmos.dc.broker.provisional.client.BrokerClient;
import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Group;
import org.eclipse.cosmos.dc.test.CommandEntry;
import org.eclipse.cosmos.dc.test.CosmosCLI;
import org.eclipse.cosmos.dc.test.Messages;
import org.eclipse.cosmos.dc.test.Tokenizer;

class CmdRegister
extends CommandEntry {
    private String _id = null;

    CmdRegister(CosmosCLI cli) {
        this._cli = cli;
        this._command = new String("Register");
        this._usage_entry = new String("USAGE_REGONE_INFO");
    }

    public boolean validateArguments(Tokenizer st, String line) {
        String s = null;
        if (!st.hasMoreTokens()) {
            this._cli.logMessage(Messages.getString("MISSING_DM_NAME_ERR"));
            return false;
        }
        this._id = st.nextToken();
        if (st.hasMoreTokens()) {
            s = st.nextToken();
            this._cli.setServiceFinder(s);
        }
        return true;
    }

    public void performAction() throws Exception {
        Iterator<?> list = null;
        DataManager dm = null;
        boolean found = false;
        list = this._cli.doFindDataManagers();
        while (list.hasNext()) {
            dm = (DataManager)list.next();
            if (!dm.getId().equals(this._id)) continue;
            found = true;
            break;
        }
        if (!found) {
            this._cli.logMessage(Messages.getString("NOT_FOUND_ERR"));
        } else {
            BrokerClient brokerclient = new BrokerClient(this._cli.getBrokerEPR());
            Group group = dm.getGroup();
            this._cli.logMessage(MessageFormat.format(Messages.getString("REGISTERING_INFO"), dm.getName()));
            if (brokerclient.registerGroup(group)) {
                this._cli.logMessage(MessageFormat.format(Messages.getString("REGISTERED_INFO"), dm.getName()));
            } else {
                this._cli.logMessage(MessageFormat.format(Messages.getString("DUPLICATE_REGISTRATION_ERR"), dm.getName()));
            }
        }
    }
}

