/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.logging.events.cbe.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.tptp.logging.events.cbe.ContentHandler;
import org.eclipse.tptp.logging.events.cbe.EventFactory;
import org.eclipse.tptp.logging.events.cbe.EventFactoryHome;
import org.eclipse.tptp.logging.events.cbe.impl.EventFactoryImpl;

public abstract class AbstractEventFactoryHome
implements EventFactoryHome {
    private Hashtable eventFactories = new Hashtable();
    private EventFactory anonymousEventFactory = null;

    public abstract ContentHandler createContentHandler(String var1);

    public abstract ContentHandler resolveContentHandler();

    public EventFactory getAnonymousEventFactory() {
        if (this.anonymousEventFactory == null) {
            this.anonymousEventFactory = new EventFactoryImpl();
            this.updateAnonymousEventFactory();
        }
        return this.anonymousEventFactory;
    }

    public EventFactory getEventFactory(String factoryName) {
        if (factoryName == null) {
            return this.getAnonymousEventFactory();
        }
        if (this.eventFactories.containsKey(factoryName)) {
            return (EventFactory)this.eventFactories.get(factoryName);
        }
        EventFactoryImpl eventFactory = new EventFactoryImpl();
        eventFactory.setContentHandler(this.createContentHandler(factoryName));
        this.eventFactories.put(factoryName, eventFactory);
        return eventFactory;
    }

    public void updateAnonymousEventFactory() {
        if (this.anonymousEventFactory != null) {
            try {
                this.anonymousEventFactory.setContentHandler(this.createContentHandler(null));
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    public void updateEventFactory(String factoryName) {
        if (factoryName == null) {
            this.updateAnonymousEventFactory();
        } else if (factoryName.trim().length() == 0 || factoryName.trim().equals("*")) {
            Enumeration eventFactoryNames = this.eventFactories.keys();
            while (eventFactoryNames.hasMoreElements()) {
                this.updateEventFactory((String)eventFactoryNames.nextElement());
            }
        } else if (this.eventFactories.containsKey(factoryName)) {
            ((EventFactory)this.eventFactories.get(factoryName)).setContentHandler(this.createContentHandler(factoryName));
        }
    }

    public void releaseEventFactory(String factoryName) {
        if (factoryName != null) {
            if (factoryName.trim().length() == 0 || factoryName.trim().equals("*")) {
                this.eventFactories.clear();
            } else if (this.eventFactories.containsKey(factoryName)) {
                this.eventFactories.remove(factoryName);
            }
        }
    }
}

