/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.smlvalidators;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementModel;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementSchemaModel;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ValidationSet;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.internal.validation.databuilders.SMLValidatingBuilder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaValidator
extends AbstractSMLValidator {
    private static final String VALIDATION_ERROR_PREFIX = "cvc";
    private static final int RESET = 0;
    private static final int CLOSE = 1;
    private ValidationSet validationSet;

    @Override
    public void initialize(Map<String, Object> init) {
        super.initialize(init);
        this.validationSet = (ValidationSet)init.get("validation.set");
    }

    @Override
    public boolean validate() {
        ElementSchemaModel[] definitions = this.validationSet.getDefinitions();
        InputStream[] schemas = this.getSchemas();
        boolean status = true;
        try {
            int i = 0;
            while (i < definitions.length) {
                this.modifyStreamState(schemas, 0);
                boolean bl = status = status && this.validateSchema(definitions[i], this.getSchemas());
                if (!status && this.shouldAbortOnError()) {
                    break;
                }
                ++i;
            }
        }
        finally {
            this.modifyStreamState(schemas, 1);
        }
        return status;
    }

    private InputStream[] getSchemas() {
        ArrayList<InputStream> schemas = new ArrayList<InputStream>();
        schemas.add(this.getClass().getClassLoader().getResourceAsStream("validation-resources/XMLSchema.xsd"));
        ElementSchemaModel[] definitions = this.validationSet.getDefinitions();
        int i = 0;
        while (i < definitions.length) {
            schemas.add(new ByteArrayInputStream(definitions[i].getSource().getBytes()));
            ++i;
        }
        return schemas.toArray(new InputStream[schemas.size()]);
    }

    private void modifyStreamState(InputStream[] streams, int state) {
        if (streams == null) {
            return;
        }
        try {
            int i = 0;
            while (i < streams.length) {
                switch (state) {
                    case 0: {
                        if (streams[i].available() > 0) break;
                        streams[i].reset();
                        break;
                    }
                    case 1: {
                        streams[i].close();
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean validateSchema(ElementSchemaModel schema, InputStream[] schemas) {
        if (schema.hasBeenValidated()) {
            return true;
        }
        ArrayList<ElementSchemaModel> schemasForValidating = new ArrayList<ElementSchemaModel>();
        ArrayList<ElementSchemaModel> instanceSchemas = new ArrayList<ElementSchemaModel>();
        instanceSchemas.add(schema);
        String[] namespaces = schema.getNamespaceContext().getNamespaces();
        int i = 0;
        while (i < namespaces.length) {
            ElementSchemaModel prereqModel;
            if (!namespaces[i].equals(schema.getTargetNamespace()) && (prereqModel = this.validationSet.getDefinitionByNamespace(namespaces[i])) != null) {
                schemasForValidating.add(prereqModel);
                this.validateSchema(prereqModel, schemas);
            }
            ++i;
        }
        try {
            SAXParser schemaParser = SMLValidatorUtil.createSAXParser(schemas, true, null, this.getValidationOutput());
            schemaParser.parse(new InputSource(new ByteArrayInputStream(schema.getSource().getBytes())), (DefaultHandler)new SMLValidatingBuilder(null));
            return true;
        }
        catch (SAXParseException e) {
            this.reportError(schema, e);
        }
        catch (Exception e) {
            this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, e.getLocalizedMessage()));
        }
        finally {
            schema.markValidated();
        }
        return false;
    }

    private void reportError(ElementModel elementModel, SAXParseException e) {
        boolean validationError = elementModel instanceof ElementSchemaModel || e.getMessage().startsWith(VALIDATION_ERROR_PREFIX);
        int lineNumber = -1;
        ElementModel errorLocation = null;
        if (validationError) {
            errorLocation = elementModel;
            lineNumber = elementModel.getLineNumber() + e.getLineNumber();
        } else {
            errorLocation = elementModel;
            lineNumber = elementModel.getLineNumber();
        }
        this.getValidationOutput().reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(errorLocation == null ? null : errorLocation.getFilePath(), lineNumber, e.getColumnNumber(), e.getLocalizedMessage()));
    }
}

