/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.smlif.editor;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.rm.internal.smlif.SMLImages;
import org.eclipse.cosmos.rm.internal.smlif.SMLPlugin;
import org.eclipse.cosmos.rm.internal.smlif.actions.ValidateResourceAction;
import org.eclipse.cosmos.rm.internal.smlif.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.internal.smlif.common.SMLMessages;
import org.eclipse.cosmos.rm.internal.smlif.common.SMLPage;
import org.eclipse.cosmos.rm.internal.smlif.editor.AbstractFormPage;
import org.eclipse.cosmos.rm.internal.smlif.editor.SMLIFEditor;
import org.eclipse.cosmos.rm.internal.smlif.importing.ui.ImportFromSMLIFWizard;
import org.eclipse.cosmos.rm.internal.validation.common.XMLInternalUtility;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverviewPage
extends AbstractFormPage {
    static String CONTEXT_ID_SMLIF_EDITOR_OVERVIEW = "org.eclipse.cosmos.rm.smlif.smlEditorOverview";
    public static final String ID = "org.eclipse.cosmos.rm.smlif.OverviewPage";
    private Text descriptionText;
    private Text nameText;
    private Text versionText;
    private Text displayNameText;
    private Text baseURIText;
    private boolean disableListener;
    private boolean showError = true;

    public OverviewPage(FormEditor editor) {
        super(editor, ID, SMLMessages.editorOverviewTitle);
    }

    @Override
    protected void createLeftColumn(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CONTEXT_ID_SMLIF_EDITOR_OVERVIEW);
        this.getManagedForm().addPart((IFormPart)((SMLIFEditor)this.getEditor()).getSmlifFormPart());
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = this.createSection(parent);
        Composite sectionClient = toolkit.createComposite((Composite)section);
        GridLayout sectionClientGL = new GridLayout(2, false);
        sectionClientGL.marginTop = 10;
        sectionClient.setLayout((Layout)sectionClientGL);
        sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        this.nameText = this.createTextField(sectionClient, SMLMessages.editorName, null, this);
        this.versionText = this.createTextField(sectionClient, SMLMessages.editorVersion, null, this);
        this.displayNameText = this.createTextField(sectionClient, SMLMessages.editorDisplayName, null, this);
        this.baseURIText = this.createTextField(sectionClient, SMLMessages.editorBaseURI, null, this);
        SMLCommonUtil.addURIValidator(this.baseURIText, new SMLPage(this));
        this.descriptionText = this.createTextField(sectionClient, SMLMessages.editorDescription, true, null, this);
        this.makeSectionReady(section, sectionClient, SMLMessages.editorGeneralInformation);
    }

    @Override
    protected void createRightColumn(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CONTEXT_ID_SMLIF_EDITOR_OVERVIEW);
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = this.createSection(parent);
        Composite sectionClient = toolkit.createComposite((Composite)section);
        GridLayout gl = new GridLayout(2, false);
        gl.marginTop = 10;
        sectionClient.setLayout((Layout)gl);
        sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        Label linkImage = toolkit.createLabel(sectionClient, "");
        linkImage.setImage(SMLImages.INSTANCE.getImage("validate.gif"));
        Hyperlink validateLink = toolkit.createHyperlink(sectionClient, SMLMessages.editorValidateDocument, 64);
        FontData[] fontData = validateLink.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(fontData[i].getStyle() | 1);
            ++i;
        }
        validateLink.setFont(new Font(null, fontData));
        validateLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IFileStore fileSelection = OverviewPage.this.getInputFile();
                if (fileSelection != null) {
                    ValidateResourceAction validateAction = new ValidateResourceAction();
                    validateAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)fileSelection));
                    validateAction.run(null);
                }
            }
        });
        linkImage = toolkit.createLabel(sectionClient, "");
        linkImage.setImage(SMLImages.INSTANCE.getImage("phenics.gif"));
        Hyperlink importLink = toolkit.createHyperlink(sectionClient, SMLMessages.editorImportModel, 64);
        importLink.setFont(new Font(null, fontData));
        importLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IFileStore fileSelection = OverviewPage.this.getInputFile();
                if (fileSelection != null) {
                    IWorkbenchWindow window = OverviewPage.this.getSite().getWorkbenchWindow();
                    ImportFromSMLIFWizard wizard = new ImportFromSMLIFWizard(OverviewPage.this.nameText.getText());
                    wizard.init(window.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)fileSelection));
                    WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
                    dialog.open();
                }
            }
        });
        this.makeSectionReady(section, sectionClient, SMLMessages.editorActionsTitle);
    }

    public void setActive(boolean active) {
        String field;
        super.setActive(active);
        if (!active) {
            return;
        }
        this.disableListener = true;
        SMLIFEditor editor = (SMLIFEditor)this.getEditor();
        if (this.showError) {
            this.showError = false;
            Node rootDocumentNode = editor.getDocumentNode();
            if (rootDocumentNode == null) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SMLMessages.errorEditorTitle, (String)SMLMessages.errorWrongRootNode);
            }
        }
        this.nameText.setText((field = editor.retrieveField(0, "name")) == null ? "" : field);
        field = editor.retrieveField(0, "version");
        this.versionText.setText(field == null ? "" : field);
        field = editor.retrieveField(0, "displayName");
        this.displayNameText.setText(field == null ? "" : field);
        field = editor.retrieveField(0, "baseURI");
        this.baseURIText.setText(field == null ? "" : field);
        field = editor.retrieveField(0, "description");
        this.descriptionText.setText(field == null ? "" : field);
        this.disableListener = false;
    }

    @Override
    public void modifyText(ModifyEvent e) {
        if (this.disableListener) {
            return;
        }
        SMLIFEditor editor = (SMLIFEditor)this.getEditor();
        IDocument document = editor.getSmlifSourcePage().getDocument();
        Node identityNode = SMLCommonUtil.nestedNodeRetrieval(editor.getDocumentNode(), new String[][]{{"http://www.w3.org/2008/09/sml-if", "identity"}}, true, false, null);
        this.modifyTextNode(editor, identityNode, e.widget == this.nameText ? "name" : (e.widget == this.versionText ? "version" : (e.widget == this.displayNameText ? "displayName" : (e.widget == this.baseURIText ? "baseURI" : "description"))), ((Text)e.widget).getText());
        try {
            StringBuffer buffer = new StringBuffer();
            XMLInternalUtility.serializeNode((StringBuffer)buffer, (Node)editor.getDocumentNode().getOwnerDocument());
            document.set(buffer.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void modifyTextNode(SMLIFEditor editor, Node node, String elementName, String newValue) {
        Node siblingToInsertBefore = this.getSiblingToInsertBefore(node, elementName);
        boolean append = siblingToInsertBefore == null;
        Node childNode = SMLCommonUtil.nestedNodeRetrieval(node, new String[][]{{"http://www.w3.org/2008/09/sml-if", elementName}}, true, append, siblingToInsertBefore);
        if (childNode == null) {
            return;
        }
        NodeList children = childNode.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            childNode.removeChild(children.item(i));
            ++i;
        }
        String encodedString = XMLInternalUtility.encodeSpecialCharacters((String)newValue);
        childNode.appendChild(childNode.getOwnerDocument().createTextNode(newValue == null ? "" : encodedString));
    }

    private Node getSiblingToInsertBefore(Node parentNode, String elementName) {
        List<String> identityNodeList = this.getIdentityNodeList();
        int elementIndex = identityNodeList.indexOf(elementName);
        if (elementIndex < 0 || elementIndex >= identityNodeList.size() - 1) {
            return null;
        }
        String siblingNodeName = identityNodeList.get(elementIndex + 1);
        Node siblingToInsertSiblingBefore = this.getSiblingToInsertBefore(parentNode, siblingNodeName);
        boolean append = siblingToInsertSiblingBefore == null;
        return SMLCommonUtil.nestedNodeRetrieval(parentNode, new String[][]{{"http://www.w3.org/2008/09/sml-if", siblingNodeName}}, true, append, siblingToInsertSiblingBefore);
    }

    private List<String> getIdentityNodeList() {
        String[] array = new String[]{"name", "version", "displayName", "description"};
        return Arrays.asList(array);
    }

    @Override
    protected void updateContent() {
        if (this.isActive()) {
            this.setActive(true);
        }
    }

    private IFileStore getInputFile() {
        IEditorInput input = this.getEditorInput();
        if (input == null) {
            MessageDialog.openError((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.errorNoInputTitle, (String)SMLMessages.errorNoInput);
            return null;
        }
        IFileStore fileSelection = null;
        try {
            if (input instanceof IURIEditorInput) {
                IFileStore file;
                fileSelection = file = EFS.getStore((URI)((IURIEditorInput)input).getURI());
            } else {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(((IPathEditorInput)input).getPath());
                fileSelection = EFS.getStore((URI)file.getRawLocationURI());
            }
        }
        catch (CoreException coreException) {}
        return fileSelection;
    }
}

