/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.repository.operations;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUnit {
    private static final String PREFIX_SEPARATOR = "_";
    private static final String URL_PREFIX = "http://";
    private static final String XML_SUFFIX = ".xml";
    private static final String XSD_SUFFIX = ".xsd";
    private static final String INSTANCE_PREFIX = "instance";
    private static final String DEFINITION_PREFIX = "definition";
    private String fileName = null;
    private StringBuffer contents = new StringBuffer();
    private ArrayList<String> aliases = new ArrayList();
    private int type = -1;
    private String filePrefix;

    public ModelUnit(int type) {
        this.type = type;
    }

    public void start() {
        this.contents.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n");
    }

    public void stop() {
    }

    public StringBuffer getFileContents() {
        return this.contents;
    }

    public String getFileName() {
        if (this.fileName == null || "".equals(this.fileName)) {
            if (this.aliases.size() > 0) {
                this.fileName = this.convertAliasToValidFileName(this.aliases.get(0));
            } else {
                File tempFile = null;
                try {
                    tempFile = File.createTempFile(String.valueOf(this.getFilePrefix()) + PREFIX_SEPARATOR, this.getFileSuffix());
                    tempFile.delete();
                }
                catch (IOException iOException) {}
                this.fileName = tempFile.getName();
            }
        }
        return this.fileName;
    }

    private String convertAliasToValidFileName(String string) {
        if (!string.startsWith(URL_PREFIX)) {
            return string;
        }
        return string.substring(URL_PREFIX.length());
    }

    private String getFilePrefix() {
        if (this.filePrefix != null) {
            return this.filePrefix;
        }
        return this.isDefinition() ? DEFINITION_PREFIX : INSTANCE_PREFIX;
    }

    private String getFileSuffix() {
        return this.isDefinition() ? XSD_SUFFIX : XML_SUFFIX;
    }

    protected boolean isDefinition() {
        return this.type == 0;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void appendToContents(String string) {
        this.contents.append(string);
    }

    public void addAlias(String string) {
        this.aliases.add(string);
    }

    public ArrayList<String> getAliases() {
        return this.aliases;
    }

    public void setFilePrefix(String localName) {
        this.filePrefix = localName;
    }
}

