/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.repository.operations.cmdbf;

import java.util.Map;
import org.eclipse.cosmos.dc.internal.cmdbf.services.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.internal.cmdbf.services.CMDBfMessages;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.IRelationshipTemplateHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.impl.AbstractQueryHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.cosmos.rm.internal.repository.RepositoryMessages;
import org.eclipse.cosmos.rm.internal.repository.operations.cmdbf.CMDBfUtil;
import org.eclipse.cosmos.rm.internal.repository.resource.SMLFileInstanceDocument;
import org.eclipse.cosmos.rm.provisional.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.provisional.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipTemplateHandler
extends AbstractQueryHandler
implements IRelationshipTemplateHandler {
    public void initialize(Map<String, Object> init) throws CMDBfServiceException {
        if (!(init.get("org.eclipse.cosmos.rm.internal.repository.operations.cmdbf.DATA_PROVIDER") instanceof ISMLRepository)) {
            throw new CMDBfServiceException(1, 5, CMDBfMessages.faultsQueryError, CMDBfInternalUtility.createTextNode((String)RepositoryMessages.errorBadInitData));
        }
        super.initialize(init);
    }

    public IEdges execute(IQueryResult result, IRelationshipTemplate relationshipTemplate, IItem source, IItem target) throws CMDBfServiceException {
        IEdges edges = QueryOutputArtifactFactory.getInstance().createEdges(relationshipTemplate);
        try {
            ISMLDocument[] references;
            ISMLRepository repository = (ISMLRepository)this.getValue("org.eclipse.cosmos.rm.internal.repository.operations.cmdbf.DATA_PROVIDER");
            SMLFileInstanceDocument sourceDocument = CMDBfUtil.retrieveDocument(repository, source);
            SMLFileInstanceDocument targetDocument = CMDBfUtil.retrieveDocument(repository, target);
            if (sourceDocument != null && targetDocument != null && (references = sourceDocument.retrieveReferences(targetDocument.getMetadata())) != null && references.length > 0) {
                IRelationship relationship = QueryOutputArtifactFactory.getInstance().createRelationship();
                String sourceId = sourceDocument.getMetadata().getId();
                String targetId = targetDocument.getMetadata().getId();
                String localId = String.valueOf(this.getLastSegment(sourceId)) + "/" + this.getLastSegment(targetId);
                relationship.addInstanceId(QueryOutputArtifactFactory.getInstance().createInstanceId("http://cosmos.org/rm/sml/repository", localId));
                relationship.setSourceId(QueryOutputArtifactFactory.getInstance().createInstanceId("http://cosmos.org/rm/sml/repository", sourceId));
                relationship.setTargetId(QueryOutputArtifactFactory.getInstance().createInstanceId("http://cosmos.org/rm/sml/repository", targetId));
                edges.addRelationship(relationship);
            }
        }
        catch (RepositoryOperationException e) {
            throw new CMDBfServiceException(1, 5, CMDBfMessages.faultsQueryError, CMDBfInternalUtility.createTextNode((String)e.getMessage()));
        }
        return edges;
    }

    private String getLastSegment(String id) {
        int inx = id.lastIndexOf(47);
        if (inx >= 0) {
            return id.substring(inx + 1);
        }
        return id;
    }
}

