/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;

/**
 * Represents the <accepted> element as part of a register response or
 * a deregister response.
 * 
 * 
 * @author David Whiteman
 */
public interface IAccepted extends IXMLWritable {
	/**
	 * Answer an array of all alternate instance ids added to
	 * the receiver
	 * 
	 * @return
	 */
	public IInstanceId[] getAlternateInstanceIds();

	/**
	 * Add an alternate instance id to the receiver
	 * 
	 * @param instanceId
	 */
	public void addAlternateInstanceId(IInstanceId instanceId);
}
