/*******************************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     CA - initial API and implementation
 *     IBM - provisional API change
 *******************************************************************************/
package org.eclipse.cosmos.dc.internal.cmdbf.services.metadata.transform.input.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.ServiceMetadataConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IRecordTypeList;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IRecordTypes;


public class RecordTypeList implements IRecordTypeList 
{
	private List<IRecordTypes> recordTypes = new ArrayList<IRecordTypes>(); // 0 or more

	
	/**
	 * add a recordTypes 
	 * 
	 * @param recordTypes
	 */
	public void addRecordTypes(IRecordTypes recordTypes){
		this.recordTypes.add(recordTypes);
	}
	
	/**
	 * get a collection of recordTypes
	 * 
	 */
	public IRecordTypes[] getRecordTypes(){
		return recordTypes.toArray(new IRecordTypes[recordTypes.size()]);
	}

	
	public void toXML(StringWriter writer, int indent) 
	{
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.beginTagFor(ServiceMetadataConstants.RECORDTYPELIST_ELEMENT)+ICMDBfServicesConstants.nl);
		
		CMDBfServicesUtil.outputListToXML(writer, indent+1, recordTypes);
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ServiceMetadataConstants.RECORDTYPELIST_ELEMENT)+ICMDBfServicesConstants.nl);
	}

	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((recordTypes == null) ? 0 : recordTypes.hashCode());
		return result;
	}


	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final RecordTypeList other = (RecordTypeList) obj;
		if (recordTypes == null) {
			if (other.recordTypes != null)
				return false;
		} else if (!recordTypes.equals(other.recordTypes))
			return false;

		return true;
	}
	
}
