/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.repository.reference;

import java.net.URI;

import org.eclipse.cosmos.rm.internal.validation.reference.XPointer;
import org.eclipse.cosmos.rm.provisional.repository.core.ISMLRepository;
import org.w3c.dom.Node;

/**
 * The fully qualified SML reference includes the document reference 
 * and the XPointer reference.  
 * 
 * @author Ali Mehregani
 */
public class SMLQualifiedReference
{
	/**
	 * The repository
	 */
	private ISMLRepository repository;
	
	/**
	 * The document reference
	 */
	private String documentReference;

	/**
	 * The xpointer expression
	 */
	private String xpointer;

	/**
	 * The constructor 
	 * 
	 * @param reference The reference
	 */
	public SMLQualifiedReference(ISMLRepository repository, String reference)
	{
		this.repository = repository;
		int anchorInx = reference.indexOf('#');
		documentReference = anchorInx >= 0 ? reference.substring(0, anchorInx) : reference;
		xpointer = anchorInx >= 0 ? reference.substring(anchorInx + 1) : null;	
	}

	
	public Node resolveReference()
	{		
		try
		{
			SMLDocumentReference docReference = new SMLDocumentReference(repository, documentReference);
			docReference.setBase(new URI(""));
			Node documentNode = docReference.retrieveDocumentDOM();
			if (xpointer == null || documentNode == null)
				return documentNode;
			
			return (Node)XPointer.compile(xpointer).evaluate(documentNode.getFirstChild());
		} 
		catch (Exception e)
		{			
			e.printStackTrace();
		} 
		
		return null;
	}


	/**
	 * @return the documentReference
	 */
	public String getDocumentReference()
	{
		return documentReference;
	}


	/**
	 * @param documentReference the documentReference to set
	 */
	public void setDocumentReference(String documentReference)
	{
		this.documentReference = documentReference;
	}


	/**
	 * @return the xpointer
	 */
	public String getXpointer()
	{
		return xpointer;
	}


	/**
	 * @param xpointer the xpointer to set
	 */
	public void setXpointer(String xpointer)
	{
		this.xpointer = xpointer;
	}		
}
