/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.provisional.repository.resource;

import org.eclipse.cosmos.rm.provisional.repository.exception.RepositoryOperationException;

/**
 * Represents an instance SML document.  An object of this type should
 * always have getMetadata().getDocumentType() return {@link ISMLMetadata#DOCUMENT_TYPE_INSTANCE}
 * 
 * 
 * @author Ali Mehregani
 */
public interface ISMLInstanceDocument extends ISMLDocument
{
	/**
	 * Retrieves and returns the definitions for this instance 
	 * document. If the definitions cannot be resolved, then an empty array
	 * will be returned.  There can be more than one definition, as
	 * per the schemaLocation field specification in XML Schema 1.0.
	 * 
	 * @return The definitions for this instance document or an empty array if
	 * they cannot be determined.
	 */
    public ISMLDefinitionDocument[] retrieveDefinitions() throws RepositoryOperationException;

    
	/**
	 * Retrieves and returns all references of this document based on
	 * the meta-data passed in.  If the argument is null, then all references
	 * of this document are returned.
	 * 
	 * @param metadata Meta information used to filter the result set of document
	 * references.
	 * @return The document references of this SML document
	 * @throws RepositoryOperationException In case of an error
	 */
    public ISMLDocument[] retrieveReferences(ISMLMetadata metadata) throws RepositoryOperationException;
}
