/**********************************************************************
 * Copyright (c) 2008, 2009 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import javax.xml.XMLConstants;

import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;

/**
 * A target element node that's embedded in a complex type.  Storing
 * the enclosing type allows us to determine whether those types
 * have a hierarchical relationship with each other.
 * 
 * @author David Whiteman
 * @author John Arwe
 */
public class EmbeddedTargetElementNode extends ConstraintNode {

	/**
	 * Xerces model object for the complex type that contains this element node
	 */
	private XSComplexTypeDefinition enclosingType;
	/**
	 * Xerces model object for the element node
	 */
	private XSElementDeclaration elementDeclaration;

	public EmbeddedTargetElementNode() {
		super();
	}

	public EmbeddedTargetElementNode(XSElementDeclaration elementDeclaration, XSComplexTypeDefinition enclosingType, 
															String targetType, String targetElement , String targetRequired ) {
		super();
		setElementDeclaration(elementDeclaration);
		setName(elementDeclaration.getName());
		setUri(elementDeclaration.getNamespace());
		setEnclosingType(enclosingType);
		// Any of the target* constraint strings may be null.  Ordinarily at least one would be non-null, but strictly speaking that is a matter of efficiency not correctness.
		// TODO Process target type/element as true Qnames.  Doing so requires namespace prefix binding resolution during parsing, which is non-trivial.
		// For now this code assumes a null target namespace, which effectively means only the local names are relevant - TargetValidator depends on this.
		if (targetType !=null)
		{
			setTargetType( XMLConstants.NULL_NS_URI , targetType );
		}
		if (targetElement !=null)
		{
			setTargetElement( XMLConstants.NULL_NS_URI , targetElement );
		}
		if (targetRequired !=null)
		{
			setTargetRequired( targetRequired );
		}
	}

	public XSElementDeclaration getElementDeclaration() {
		return elementDeclaration;
	}

	public void setElementDeclaration(XSElementDeclaration elementDeclaration) {
		this.elementDeclaration = elementDeclaration;
	}

	public void setEnclosingType(XSComplexTypeDefinition enclosingType) {
		this.enclosingType = enclosingType;
	}

	public XSComplexTypeDefinition getEnclosingType() {
		return enclosingType;
	}

	public String getQualifiedName() {
		return SMLValidatorUtil.createQualifiedName(getUri(), getName());
	}
}
