/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.common;

/**
 * An SMLValidationException is thrown when there is a error in 
 * validating an SML/SML-IF file.  This exception will almost always
 * wrap another exception as the cause.
 * 
 * @author Ali Mehregani
 */
public class SMLValidationException extends Exception
{
	/**
	 * The serial version UID
	 */
	private static final long serialVersionUID = 8398843666844048682L;
		
	/**
	 * The line number associated with the exception
	 */
	private int lineNumber;

	public SMLValidationException()
	{
		super();
	}
		
	public SMLValidationException (Throwable t)
	{
		super(t.getLocalizedMessage(), t);
	}
	
	/**
	 * @return the lineNumber
	 */
	public int getLineNumber()
	{
		return lineNumber;
	}

	/**
	 * @param lineNumber the lineNumber to set
	 */
	public void setLineNumber(int lineNumber)
	{
		this.lineNumber = lineNumber;
	}	
	
}
