/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import org.eclipse.cosmos.me.sdd.advisor.IAdvisor;
import org.eclipse.cosmos.me.sdd.cli.Messages;
import org.eclipse.cosmos.me.sdd.schema.BooleanParameterType;
import org.eclipse.cosmos.me.sdd.schema.IntegerParameterType;
import org.eclipse.cosmos.me.sdd.schema.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.StringParameterType;
import org.eclipse.cosmos.me.sdd.schema.URIParameterType;

public class CLIAdvisor
implements IAdvisor {
    private static final String ONE = "1";
    private static final String ZERO = "0";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

    public void displayMessage(String message) {
        System.out.println(message);
    }

    public Integer requestParameter(IntegerParameterType ipt) {
        String value = this.readVariable(ipt.getDisplayName() != null ? ipt.getDisplayName().getValue() : null, ipt.getDefaultValue());
        Integer returnVal = null;
        try {
            returnVal = Integer.parseInt(value);
        }
        catch (Exception exception) {
            this.displayMessage(Messages.getString("CLIAdvisor.ProvideEntry"));
            return this.requestParameter(ipt);
        }
        return returnVal;
    }

    public String requestParameter(StringParameterType spt) {
        return this.readVariable(spt.getDisplayName() != null ? spt.getDisplayName().getValue() : null, spt.getDefaultValue());
    }

    public Boolean requestParameter(BooleanParameterType bpt) {
        String value = this.readVariable(bpt.getDisplayName() != null ? bpt.getDisplayName().getValue() : null, bpt.getDefaultValue());
        if (value.equalsIgnoreCase(ONE)) {
            return true;
        }
        if (value.equalsIgnoreCase(ZERO)) {
            return false;
        }
        if (value.equalsIgnoreCase(TRUE)) {
            return true;
        }
        if (value.equalsIgnoreCase(FALSE)) {
            return false;
        }
        this.displayMessage(Messages.getString("CLIAdvisor.ProvideEntry"));
        return this.requestParameter(bpt);
    }

    public URI requestParameter(URIParameterType upt) {
        URI returnVal = null;
        try {
            returnVal = URI.create(this.readVariable(upt.getDisplayName() != null ? upt.getDisplayName().getValue() : null, upt.getDefaultValue()));
        }
        catch (Exception exception) {
            return this.requestParameter(upt);
        }
        return returnVal;
    }

    private String readVariable(String name, String defaultVal) {
        boolean hasDefault = false;
        if (name == null) {
            name = Messages.getString("CLIAdvisor.MissingDisplayName");
        }
        if (defaultVal != null && defaultVal.length() > 0) {
            hasDefault = true;
            System.out.print(Messages.getString("CLIAdvisor.UseDefault", name, defaultVal));
        } else {
            System.out.print(Messages.getString("CLIAdvisor.ProvideValue", name));
        }
        String value = null;
        try {
            value = this.br.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (value == null || value.length() == 0) {
            value = hasDefault ? defaultVal : this.readVariable(name, defaultVal);
        }
        return value;
    }

    public void displayError(RequirementResourceConstraintType resource) {
        ResourceType rsrc = (ResourceType)resource.getResourceRef();
        this.displayMessage(Messages.getString("CLIAdvisor.FailedResolution", resource.getId(), rsrc.getName()));
    }
}

