/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.cim.profile;

import java.io.File;
import org.eclipse.cosmos.me.sdd.cr.Constraint;
import org.eclipse.cosmos.me.sdd.cr.IResolver;
import org.eclipse.cosmos.me.sdd.schema.ext.ResolutionObject;

public class DirectoryResolver
implements IResolver {
    public ResolutionObject resolve(Constraint c) {
        ResolutionObject resolution = new ResolutionObject();
        if (c.getType().equalsIgnoreCase("property")) {
            return this.resolveProperty(c, resolution);
        }
        if (c.getType().equalsIgnoreCase("version")) {
            return this.resolveVersion(c, resolution);
        }
        if (c.getType().equalsIgnoreCase("capacity")) {
            return this.resolveCapacity(c, resolution);
        }
        if (c.getType().equalsIgnoreCase("consumption")) {
            return this.resolveConsumption(c, resolution);
        }
        return resolution;
    }

    private ResolutionObject resolveConsumption(Constraint c, ResolutionObject resolution) {
        System.out.println("DirectoryResolver.resolveConsumption() - not implemented.");
        return resolution;
    }

    private ResolutionObject resolveCapacity(Constraint c, ResolutionObject resolution) {
        System.out.println("DirectoryResolver.resolveCapacity() - not implemented.");
        return resolution;
    }

    private ResolutionObject resolveVersion(Constraint c, ResolutionObject resolution) {
        System.out.println("DirectoryResolver.resolveVersion() - not implemented.");
        return resolution;
    }

    private ResolutionObject resolveProperty(Constraint c, ResolutionObject resolution) {
        for (String name : c.getNames()) {
            if (name.endsWith("Readable")) {
                return this.resolveDirectoryReadable(name, c, resolution);
            }
            if (!name.endsWith("Writable")) continue;
            return this.resolveDirectoryWritable(name, c, resolution);
        }
        return null;
    }

    private ResolutionObject resolveDirectoryWritable(String name, Constraint c, ResolutionObject resolution) {
        File directory = new File(c.getResource());
        directory.mkdirs();
        String[] values = c.getValues(name);
        boolean compareTo = Boolean.parseBoolean(values[0]);
        if (directory.canWrite() == compareTo) {
            resolution.accept();
            c.accept();
        } else {
            resolution.reject();
            c.reject();
        }
        return resolution;
    }

    private ResolutionObject resolveDirectoryReadable(String name, Constraint c, ResolutionObject resolution) {
        File directory = new File(c.getResource());
        String[] values = c.getValues(name);
        boolean compareTo = Boolean.getBoolean(values[0]);
        if (directory.canRead() == compareTo) {
            resolution.accept();
            c.accept();
        } else {
            resolution.reject();
            c.reject();
        }
        return resolution;
    }
}

