/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.cim.profile;

import org.eclipse.cosmos.me.sdd.cr.Constraint;
import org.eclipse.cosmos.me.sdd.cr.IResolver;
import org.eclipse.cosmos.me.sdd.schema.ext.ResolutionObject;

public class OperatingSystemResolver
implements IResolver {
    public ResolutionObject resolve(Constraint c) {
        ResolutionObject resolution = new ResolutionObject();
        if (c.getType().equalsIgnoreCase("property")) {
            return this.resolveProperty(c, resolution);
        }
        if (c.getType().equalsIgnoreCase("version")) {
            return this.resolveVersion(c, resolution);
        }
        if (c.getType().equalsIgnoreCase("capacity")) {
            return this.resolveCapacity(c, resolution);
        }
        if (c.getType().equalsIgnoreCase("consumption")) {
            return this.resolveConsumption(c, resolution);
        }
        return resolution;
    }

    private ResolutionObject resolveConsumption(Constraint c, ResolutionObject resolution) {
        System.out.println("OperatingSystemResolver.resolveConsumption() - not implemented.");
        return resolution;
    }

    private ResolutionObject resolveCapacity(Constraint c, ResolutionObject resolution) {
        System.out.println("OperatingSystemResolver.resolveCapacity() - not implemented.");
        return resolution;
    }

    private ResolutionObject resolveVersion(Constraint c, ResolutionObject resolution) {
        for (String name : c.getNames()) {
            this.resolveOSVersion(name, c, resolution);
        }
        return resolution;
    }

    private ResolutionObject resolveProperty(Constraint c, ResolutionObject resolution) {
        for (String name : c.getNames()) {
            if (name.endsWith("OSType")) {
                this.resolveOSType(name, c, resolution);
                continue;
            }
            if (!name.endsWith("Version")) continue;
            this.resolveOSVersion(name, c, resolution);
        }
        return resolution;
    }

    private ResolutionObject resolveOSType(String name, Constraint c, ResolutionObject resolution) {
        String osName = System.getProperty("os.name");
        String[] values = c.getValues(name);
        int i = 0;
        while (i < values.length) {
            String val = values[i];
            if (val.equalsIgnoreCase(osName)) {
                resolution.accept();
                c.accept();
            } else {
                resolution.reject();
                c.reject();
            }
            ++i;
        }
        return resolution;
    }

    private ResolutionObject resolveOSVersion(String name, Constraint c, ResolutionObject resolution) {
        String[] values;
        float sdd_value;
        String osVersion = System.getProperty("os.version");
        float version = this.convertVersion(osVersion);
        boolean passes = false;
        if (name.equals("minimum")) {
            String[] values2 = c.getValues(name);
            float sdd_value2 = this.convertVersion(values2[0]);
            if (sdd_value2 <= version) {
                passes = true;
            }
        } else if (name.equalsIgnoreCase("maximum") && (sdd_value = this.convertVersion((values = c.getValues(name))[0])) >= version) {
            passes = true;
        }
        if (passes) {
            resolution.accept();
            c.accept();
        } else {
            resolution.reject();
            c.reject();
        }
        return resolution;
    }

    private float convertVersion(String version) {
        String[] pieces = version.split("\\.");
        if (pieces.length == 1) {
            return Float.parseFloat(pieces[0]);
        }
        return Float.parseFloat(String.valueOf(pieces[0]) + "." + pieces[1]);
    }
}

