/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.cr.impl;

import java.text.MessageFormat;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.me.sdd.cr.Constraint;
import org.eclipse.cosmos.me.sdd.cr.IResolver;
import org.eclipse.cosmos.me.sdd.cr.ResolverByQname;
import org.eclipse.cosmos.me.sdd.schema.ext.ResolutionObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class ResolverByQnameImpl
implements ResolverByQname {
    static final String QUERY = "(qname={0})";
    private BundleContext context;

    protected void activate(ComponentContext ctxt) {
        this.context = ctxt.getBundleContext();
    }

    protected void deactivate(ComponentContext ctxt) {
        this.context = null;
    }

    public ResolutionObject resolve(String qname, Constraint c) {
        ResolutionObject result = null;
        ServiceReference ref = this.lookup(qname);
        if (ref != null) {
            IResolver r = (IResolver)this.context.getService(ref);
            if (r != null) {
                result = r.resolve(c);
            }
            this.context.ungetService(ref);
        }
        return result;
    }

    public ResolutionObject resolve(QName qname, Constraint c) {
        return this.resolve(qname.toString(), c);
    }

    private ServiceReference lookup(String qname) {
        ServiceReference ref = null;
        String query = MessageFormat.format(QUERY, qname);
        try {
            ServiceReference[] refs = this.context.getServiceReferences(IResolver.class.getName(), query);
            if (refs != null && refs.length > 0) {
                ref = refs[0];
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
        return ref;
    }
}

