/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.op.listener.event.impl;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.cosmos.me.sdd.op.listener.EntryData;
import org.eclipse.cosmos.me.sdd.op.listener.event.InstallationCompletion;
import org.eclipse.cosmos.me.sdd.op.listener.event.InstallationProgress;
import org.eclipse.cosmos.me.sdd.op.listener.event.InstallationRollback;
import org.eclipse.cosmos.me.sdd.op.listener.event.InstallationSetup;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class Broker
implements InstallationCompletion,
InstallationProgress,
InstallationSetup,
InstallationRollback {
    private EventAdmin eventAdmin;

    public synchronized void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public synchronized void unsetEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = null;
    }

    public void installationCancelled() {
        this.eventAdmin.postEvent(new Event(InstallationCompletion.Topic.CANCELLED.value(), null));
    }

    public void installationComplete() {
        this.eventAdmin.postEvent(new Event(InstallationCompletion.Topic.COMPLETE.value(), null));
    }

    public void installationFailure(String description) {
        Properties props = new Properties();
        props.put("description", description);
        this.eventAdmin.postEvent(new Event(InstallationCompletion.Topic.FAILURE.value(), (Dictionary)props));
    }

    public synchronized void bytesMoved(long numBytes) {
        Properties props = new Properties();
        props.put("bytes", (Object)numBytes);
        this.eventAdmin.postEvent(new Event(InstallationProgress.Topic.BYTES_MOVED.value(), (Dictionary)props));
    }

    public void progressBeginningAction(String action, EntryData metaData) {
        Properties props = new Properties();
        props.put("action", action);
        props.put("metadata", metaData);
        this.eventAdmin.postEvent(new Event(InstallationProgress.Topic.BEGINNING.value(), (Dictionary)props));
    }

    public void progressBeginningAction(String description) {
        Properties props = new Properties();
        props.put("description", description);
        this.eventAdmin.postEvent(new Event(InstallationProgress.Topic.BEGINNING.value(), (Dictionary)props));
    }

    public void progressCompleteAction(String action, EntryData metaData) {
        Properties props = new Properties();
        props.put("action", action);
        props.put("metadata", metaData);
        this.eventAdmin.postEvent(new Event(InstallationProgress.Topic.COMPLETE.value(), (Dictionary)props));
    }

    public void progressCompleteAction(String description) {
        Properties props = new Properties();
        props.put("description", description);
        this.eventAdmin.postEvent(new Event(InstallationProgress.Topic.COMPLETE.value(), (Dictionary)props));
    }

    public void progressFailedAction(String action, EntryData metaData) {
        Properties props = new Properties();
        props.put("action", action);
        props.put("metadata", metaData);
        this.eventAdmin.postEvent(new Event(InstallationProgress.Topic.FAILED.value(), (Dictionary)props));
    }

    public void setupAction(String action, EntryData metaData) {
        Properties props = new Properties();
        props.put("action", action);
        props.put("metadata", metaData);
        this.eventAdmin.postEvent(new Event(InstallationSetup.Topic.SETUP.value(), (Dictionary)props));
    }

    public void setupAction(String description) {
        Properties props = new Properties();
        props.put("description", description);
        this.eventAdmin.postEvent(new Event(InstallationSetup.Topic.SETUP.value(), (Dictionary)props));
    }

    public void allRollbackCompleteAction() {
        this.eventAdmin.postEvent(new Event(InstallationRollback.Topic.ALL_COMPLETE.value(), null));
    }

    public void rollbackBytesMoved(long numBytes) {
        Properties props = new Properties();
        props.put("bytes", (Object)numBytes);
        this.eventAdmin.postEvent(new Event(InstallationRollback.Topic.BYTES_MOVED.value(), (Dictionary)props));
    }

    public void rollbackFailure(String description) {
        Properties props = new Properties();
        props.put("description", description);
        this.eventAdmin.postEvent(new Event(InstallationRollback.Topic.FAILURE.value(), (Dictionary)props));
    }

    public void rollbackProgressBeginningAction(String action, EntryData metaData) {
        Properties props = new Properties();
        props.put("action", action);
        props.put("metadata", metaData);
        this.eventAdmin.postEvent(new Event(InstallationRollback.Topic.BEGINNING.value(), (Dictionary)props));
    }

    public void rollbackProgressBeginningAction(String description) {
        Properties props = new Properties();
        props.put("description", description);
        this.eventAdmin.postEvent(new Event(InstallationRollback.Topic.BEGINNING.value(), (Dictionary)props));
    }

    public void rollbackProgressCompleteAction(String action, EntryData metaData) {
        Properties props = new Properties();
        props.put("action", action);
        props.put("metadata", metaData);
        this.eventAdmin.postEvent(new Event(InstallationRollback.Topic.COMPLETE.value(), (Dictionary)props));
    }

    public void rollbackProgressCompleteAction(String description) {
        Properties props = new Properties();
        props.put("description", description);
        this.eventAdmin.postEvent(new Event(InstallationRollback.Topic.COMPLETE.value(), (Dictionary)props));
    }
}

