/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.op.listener.event.impl;

import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cosmos.me.sdd.op.listener.EntryData;
import org.eclipse.cosmos.me.sdd.op.listener.InstallListener;
import org.eclipse.cosmos.me.sdd.op.listener.InstallationCompletionListener;
import org.eclipse.cosmos.me.sdd.op.listener.InstallationProgressListener;
import org.eclipse.cosmos.me.sdd.op.listener.InstallationRollbackListener;
import org.eclipse.cosmos.me.sdd.op.listener.InstallationSetupListener;
import org.eclipse.cosmos.me.sdd.op.listener.event.IRegistry;
import org.eclipse.cosmos.me.sdd.op.listener.event.InstallationCompletion;
import org.eclipse.cosmos.me.sdd.op.listener.event.InstallationProgress;
import org.eclipse.cosmos.me.sdd.op.listener.event.InstallationRollback;
import org.eclipse.cosmos.me.sdd.op.listener.event.InstallationSetup;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class Registry
implements IRegistry {
    private BundleContext context;
    private Map<InstallListener, ServiceRegistration> registrations = new LinkedHashMap<InstallListener, ServiceRegistration>();

    protected void activate(ComponentContext ctxt) {
        this.context = ctxt.getBundleContext();
    }

    protected void deactivate(ComponentContext ctxt) {
        for (ServiceRegistration reg : this.registrations.values()) {
            reg.unregister();
        }
        this.registrations.clear();
        this.context = null;
    }

    public void addListener(InstallListener listener) {
        if (listener != null) {
            ServiceRegistration reg;
            Properties props;
            if (listener instanceof InstallationCompletionListener) {
                props = new Properties();
                props.put("event.topics", InstallationCompletion.Topic.FILTER.value());
                reg = this.context.registerService(EventHandler.class.getName(), (Object)this.createInstallCompletionHandler((InstallationCompletionListener)listener), (Dictionary)props);
                if (reg != null) {
                    this.registrations.put(listener, reg);
                }
            }
            if (listener instanceof InstallationProgressListener) {
                props = new Properties();
                props.put("event.topics", InstallationProgress.Topic.FILTER.value());
                reg = this.context.registerService(EventHandler.class.getName(), (Object)this.createInstallProgressHandler((InstallationProgressListener)listener), (Dictionary)props);
                if (reg != null) {
                    this.registrations.put(listener, reg);
                }
            }
            if (listener instanceof InstallationSetupListener) {
                props = new Properties();
                props.put("event.topics", InstallationSetup.Topic.FILTER.value());
                reg = this.context.registerService(EventHandler.class.getName(), (Object)this.createInstallSetupHandler((InstallationSetupListener)listener), (Dictionary)props);
                if (reg != null) {
                    this.registrations.put(listener, reg);
                }
            }
            if (listener instanceof InstallationRollbackListener) {
                InstallationRollbackListener l = (InstallationRollbackListener)listener;
                Properties props2 = new Properties();
                props2.put("event.topics", InstallationRollback.Topic.FILTER.value());
                ServiceRegistration reg2 = this.context.registerService(EventHandler.class.getName(), (Object)this.createInstallRollbackHandler(l), (Dictionary)props2);
                if (reg2 != null) {
                    this.registrations.put(listener, reg2);
                }
            }
        }
    }

    public void removeListener(InstallListener listener) {
        if (listener != null) {
            this.registrations.remove(listener);
        }
    }

    private EventHandler createInstallCompletionHandler(final InstallationCompletionListener listener) {
        return new EventHandler(){

            public void handleEvent(Event event) {
                InstallationCompletion.Topic topic = InstallationCompletion.Topic.getValue((String)event.getProperty("event.topics"));
                String description = (String)event.getProperty("description");
                switch (topic) {
                    case COMPLETE: {
                        listener.installationComplete();
                        break;
                    }
                    case CANCELLED: {
                        listener.installationCancelled();
                        break;
                    }
                    case FAILURE: {
                        listener.installationFailure(description);
                    }
                }
            }
        };
    }

    private EventHandler createInstallProgressHandler(final InstallationProgressListener listener) {
        return new EventHandler(){

            public void handleEvent(Event event) {
                InstallationProgress.Topic topic = InstallationProgress.Topic.getValue((String)event.getProperty("event.topics"));
                String description = (String)event.getProperty("description");
                String action = (String)event.getProperty("action");
                EntryData metaData = (EntryData)event.getProperty("metadata");
                Long numBytes = (Long)event.getProperty("bytes");
                switch (topic) {
                    case BEGINNING: {
                        if (action != null) {
                            listener.progressBeginningAction(action, metaData);
                            break;
                        }
                        listener.progressBeginningAction(description);
                        break;
                    }
                    case COMPLETE: {
                        if (action != null) {
                            listener.progressCompleteAction(action, metaData);
                            break;
                        }
                        listener.progressCompleteAction(description);
                        break;
                    }
                    case FAILED: {
                        listener.progressFailedAction(action, metaData);
                        break;
                    }
                    case BYTES_MOVED: {
                        listener.bytesMoved(numBytes);
                    }
                }
            }
        };
    }

    private EventHandler createInstallSetupHandler(final InstallationSetupListener listener) {
        return new EventHandler(){

            public void handleEvent(Event event) {
                InstallationSetup.Topic topic = InstallationSetup.Topic.getValue((String)event.getProperty("event.topics"));
                String description = (String)event.getProperty("description");
                String action = (String)event.getProperty("action");
                EntryData metaData = (EntryData)event.getProperty("metadata");
                switch (topic) {
                    case SETUP: {
                        if (action != null) {
                            listener.setupAction(action, metaData);
                            break;
                        }
                        listener.setupAction(description);
                    }
                }
            }
        };
    }

    private EventHandler createInstallRollbackHandler(final InstallationRollbackListener listener) {
        return new EventHandler(){

            public void handleEvent(Event event) {
                InstallationRollback.Topic topic = InstallationRollback.Topic.getValue((String)event.getProperty("event.topics"));
                String description = (String)event.getProperty("description");
                String action = (String)event.getProperty("action");
                EntryData metaData = (EntryData)event.getProperty("metadata");
                Long numBytes = (Long)event.getProperty("bytes");
                switch (topic) {
                    case BEGINNING: {
                        if (action != null) {
                            listener.rollbackProgressBeginningAction(action, metaData);
                            break;
                        }
                        listener.rollbackProgressBeginningAction(description);
                        break;
                    }
                    case COMPLETE: {
                        if (action != null) {
                            listener.rollbackProgressCompleteAction(action, metaData);
                            break;
                        }
                        listener.rollbackProgressCompleteAction(description);
                        break;
                    }
                    case BYTES_MOVED: {
                        listener.rollbackBytesMoved(numBytes);
                        break;
                    }
                    case FAILURE: {
                        listener.rollbackFailure(description);
                        break;
                    }
                    case ALL_COMPLETE: {
                        listener.allRollbackCompleteAction();
                    }
                }
            }
        };
    }
}

