/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.o10r.impl;

import org.eclipse.cosmos.me.sdd.advisor.IAdvisor;
import org.eclipse.cosmos.me.sdd.cr.ResourceHandler;
import org.eclipse.cosmos.me.sdd.o10r.Orchestrator;
import org.eclipse.cosmos.me.sdd.o10r.impl.RequirementsResolver;
import org.eclipse.cosmos.me.sdd.o10r.impl.SddContextImpl;
import org.eclipse.cosmos.me.sdd.o10r.impl.VariableResolver;
import org.eclipse.cosmos.me.sdd.op.OperationHandler;
import org.eclipse.cosmos.me.sdd.schema.AdditionalContentType;
import org.eclipse.cosmos.me.sdd.schema.ArtifactType;
import org.eclipse.cosmos.me.sdd.schema.BooleanParameterType;
import org.eclipse.cosmos.me.sdd.schema.DeploymentDescriptorType;
import org.eclipse.cosmos.me.sdd.schema.InstallableUnitType;
import org.eclipse.cosmos.me.sdd.schema.InstallationArtifactsType;
import org.eclipse.cosmos.me.sdd.schema.IntegerParameterType;
import org.eclipse.cosmos.me.sdd.schema.OperationType;
import org.eclipse.cosmos.me.sdd.schema.PackageDescriptorType;
import org.eclipse.cosmos.me.sdd.schema.StringParameterType;
import org.eclipse.cosmos.me.sdd.schema.URIParameterType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;
import org.eclipse.cosmos.me.sdd.schema.marshal.Marshaller;

public class OrchestratorImpl
implements Orchestrator {
    private Marshaller marshaller;
    private OperationHandler ophandler;
    private ResourceHandler rsrcHandler;
    private IAdvisor advisor;

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void unsetMarshaller(Marshaller marshaller) {
        this.marshaller = null;
    }

    public void setOperationHandler(OperationHandler ophandler) {
        this.ophandler = ophandler;
    }

    public void unsetOperationHandler(OperationHandler ophandler) {
        this.ophandler = null;
    }

    public void setResourceHandler(ResourceHandler rsrcHandler) {
        this.rsrcHandler = rsrcHandler;
    }

    public void unsetResourceHandler(ResourceHandler rsrcHandler) {
        this.rsrcHandler = null;
    }

    public void setAdvisor(IAdvisor advisor) {
        this.advisor = advisor;
    }

    public void unsetAdvisor(IAdvisor advisor) {
        this.advisor = null;
    }

    public void deploy(String packageUri, String operation) {
        OperationType op = OperationType.fromValue((String)operation);
        switch (op) {
            case INSTALL: 
            case UNINSTALL: {
                this.installableUnit(packageUri, op);
                break;
            }
        }
    }

    private void installableUnit(String packageUri, OperationType op) {
        InstallableUnitType unit;
        DeploymentDescriptorType dd;
        SddContextImpl ctxt = new SddContextImpl(this.marshaller, packageUri);
        PackageDescriptorType pd = ctxt.getPackageDescriptor();
        if (pd != null && (dd = ctxt.getDeploymentDescriptor()) != null && this.installableUnitResolution(ctxt) && (unit = dd.getInstallableUnit()) != null && unit.getArtifacts() != null) {
            InstallationArtifactsType artifacts = unit.getArtifacts();
            switch (op) {
                case INSTALL: {
                    if (artifacts.getInstallArtifact() == null) break;
                    ArtifactType artifact = artifacts.getInstallArtifact();
                    this.ophandler.invokeAction((SDDContext)ctxt, artifact, op);
                    for (AdditionalContentType c : artifact.getAdditionalContent()) {
                        this.ophandler.invokeAction((SDDContext)ctxt, artifact, c, op);
                    }
                    break;
                }
                case UNINSTALL: {
                    if (artifacts.getUninstallArtifact() == null) break;
                    this.ophandler.invokeAction((SDDContext)ctxt, artifacts.getUninstallArtifact(), op);
                }
            }
        }
    }

    private boolean installableUnitResolution(SDDContext ctxt) {
        new VariableResolver(ctxt, this.rsrcHandler).installableUnitResolver();
        RequirementsResolver reqResolver = new RequirementsResolver(ctxt, this.rsrcHandler);
        if (ctxt.getParameters().size() > 0) {
            if (this.advisor != null) {
                for (Object p : ctxt.getParameters().values()) {
                    if (p instanceof URIParameterType) {
                        ctxt.setVariable(((URIParameterType)p).getId(), this.advisor.requestParameter((URIParameterType)p).toString());
                    } else if (p instanceof IntegerParameterType) {
                        ctxt.setVariable(((IntegerParameterType)p).getId(), this.advisor.requestParameter((IntegerParameterType)p).toString());
                    } else if (p instanceof StringParameterType) {
                        ctxt.setVariable(((StringParameterType)p).getId(), this.advisor.requestParameter((StringParameterType)p));
                    } else if (p instanceof BooleanParameterType) {
                        ctxt.setVariable(((BooleanParameterType)p).getId(), this.advisor.requestParameter((BooleanParameterType)p).toString());
                    }
                    if (reqResolver.installableUnitResolver()) continue;
                    this.advisor.displayError(reqResolver.getUnsatisifiedResource());
                    return false;
                }
            } else if (!reqResolver.installableUnitResolver()) {
                this.advisor.displayError(reqResolver.getUnsatisifiedResource());
                return false;
            }
        }
        return true;
    }
}

